/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.message.parser;

import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.util.exception.ContentException;
import org.qubership.automation.itf.core.util.helper.ContentHelper;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.qubership.automation.itf.core.util.services.CoreServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);

    public JsonContext parseToJsonContext(Message message, Collection<? extends ParsingRule> parsingRules, BigInteger projectId) {
        Map<String, MessageParameter> parsedParameters = this.parse(projectId, message, null, parsingRules);
        JsonContext context = new JsonContext();
        for (Map.Entry<String, MessageParameter> parameter : parsedParameters.entrySet()) {
            context.put(parameter.getKey(), parameter.getValue().isMultiple() ? parameter.getValue().getMultipleValue() : parameter.getValue().getSingleValue());
        }
        return context;
    }

    public Map<String, MessageParameter> parse(BigInteger projectId, Message message, InstanceContext instanceContext, ParsingRuleProvider ... providers) {
        log.debug("Parse start");
        if (providers.length > 0) {
            log.debug("ParsingRuleProviders.length = {}", (Object)providers.length);
            HashMap parameters = Maps.newHashMapWithExpectedSize((int)(providers.length * 5));
            for (ParsingRuleProvider provider : providers) {
                if (provider == null) continue;
                log.debug("ParsingRuleProvider is '{}', parsingRules count = {}", (Object)provider.getName(), (Object)provider.returnParsingRules().size());
                this.applyRules(message, provider.returnParsingRules(), parameters, instanceContext, projectId);
            }
            log.debug("Parse finish");
            return parameters;
        }
        log.debug("ParsingRuleProviders.length = 0. Parse finish.");
        return Collections.emptyMap();
    }

    public Map<String, MessageParameter> parse(BigInteger projectId, Message message, InstanceContext instanceContext, Collection<? extends ParsingRule> parsingRules) {
        HashMap parameters = Maps.newHashMapWithExpectedSize((int)20);
        this.applyRules(message, parsingRules, parameters, instanceContext, projectId);
        return parameters;
    }

    private void applyRules(Message message, Collection<? extends ParsingRule> parsingRules, Map<String, MessageParameter> parameters, InstanceContext instanceContext, BigInteger projectId) {
        HashMap contentTypes = Maps.newHashMapWithExpectedSize((int)3);
        boolean expressionVarSetting = Boolean.parseBoolean(CoreServices.getProjectSettingsService().get(projectId, "expression.var", "false"));
        for (ParsingRule parsingRule : parsingRules) {
            if (StringUtils.isBlank((CharSequence)parsingRule.getParamName()) || parameters.get(parsingRule.getParamName()) != null) continue;
            log.debug("prepared parsingRule is '{}'", (Object)parsingRule.getParamName());
            String parsingRuleType = parsingRule.getParsingType().toString();
            if (contentTypes.containsKey(parsingRuleType) && !((Boolean)contentTypes.get(parsingRuleType)).booleanValue()) continue;
            try {
                ContentHelper.getInstance().trySetContent(message, parsingRuleType);
                if (parsingRule.applicable(message)) {
                    contentTypes.put(parsingRuleType, true);
                    long startTime = System.currentTimeMillis();
                    MessageParameter parameter = parsingRule.apply(message, instanceContext, expressionVarSetting);
                    String paramName = parameter.getParamName();
                    this.longDurationWarning(startTime, paramName, parsingRule.getParsedExpression());
                    if (parameter.getMultipleValue().isEmpty() || StringUtils.isBlank((CharSequence)parameter.getSingleValue())) continue;
                    log.debug("Found message parameter: [{}] = '{}'", (Object)paramName, (Object)parameter.getSingleValue());
                    parameters.put(paramName, parameter);
                    continue;
                }
                contentTypes.put(parsingRuleType, false);
            }
            catch (ContentException ex) {
                contentTypes.put(parsingRuleType, false);
                log.error("Message parsing is failed (probably incorrect message format).  Rule '{}' (expression: '{}') at {}\nException: ", new Object[]{parsingRule.getParamName(), parsingRule.getParsedExpression(), parsingRule.getParsingRulePath(), ex});
            }
            catch (Throwable ex) {
                log.error("Applying rule '{}' (expression: '{}') at {} failed with exception ", new Object[]{parsingRule.getParamName(), parsingRule.getParsedExpression(), parsingRule.getParsingRulePath(), ex});
            }
        }
    }

    private void longDurationWarning(long startTime, String paramName, String expression) {
        long duration = System.currentTimeMillis() - startTime;
        if (duration > 2000L) {
            log.warn("Too slow parsing: {} ms (paramName: {}, expression: {})", new Object[]{duration, paramName, expression});
        }
    }
}

