/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.communication.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import org.qubership.automation.itf.core.model.communication.StubUser;
import org.qubership.automation.itf.core.model.communication.TriggerSample;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ServerTriggerSyncRequest {
    private List<TriggerSample> triggerIdToDeactivate;
    private List<TriggerSample> triggerIdToReactivate;
    private StubUser user;
    private String sessionId;

    public ServerTriggerSyncRequest(List<TriggerSample> triggerIdToDeactivate, List<TriggerSample> triggerIdToReactivate, StubUser user, String sessionId) {
        this.triggerIdToDeactivate = triggerIdToDeactivate;
        this.triggerIdToReactivate = triggerIdToReactivate;
        this.user = user;
        this.sessionId = sessionId;
    }

    public ServerTriggerSyncRequest() {
        this.triggerIdToDeactivate = new ArrayList<TriggerSample>();
        this.triggerIdToReactivate = new ArrayList<TriggerSample>();
        this.user = null;
        this.sessionId = "";
    }

    public void merge(ServerTriggerSyncRequest requestToMergeWith) {
        this.triggerIdToDeactivate.addAll(requestToMergeWith.getTriggerIdToDeactivate());
        this.triggerIdToReactivate.addAll(requestToMergeWith.getTriggerIdToReactivate());
        if (this.getUser() == null) {
            this.setUser(requestToMergeWith.getUser());
        }
        if (this.getSessionId().isEmpty()) {
            this.setSessionId(requestToMergeWith.getSessionId());
        }
    }

    public List<TriggerSample> getTriggerIdToDeactivate() {
        return this.triggerIdToDeactivate;
    }

    public List<TriggerSample> getTriggerIdToReactivate() {
        return this.triggerIdToReactivate;
    }

    public StubUser getUser() {
        return this.user;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setTriggerIdToDeactivate(List<TriggerSample> triggerIdToDeactivate) {
        this.triggerIdToDeactivate = triggerIdToDeactivate;
    }

    public void setTriggerIdToReactivate(List<TriggerSample> triggerIdToReactivate) {
        this.triggerIdToReactivate = triggerIdToReactivate;
    }

    public void setUser(StubUser user) {
        this.user = user;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}

