/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.communication.message;

import java.math.BigInteger;
import java.util.Map;
import org.qubership.automation.itf.core.model.communication.StubUser;
import org.qubership.automation.itf.core.util.constants.TriggerState;

public abstract class TriggerStateResponse {
    private Map<BigInteger, TriggerState> states;
    private String errorMessage;
    private StubUser user;
    private String sessionId;

    public TriggerStateResponse(Map<BigInteger, TriggerState> states, String errorMessage, StubUser user, String sessionId) {
        this.states = states;
        this.errorMessage = errorMessage;
        this.user = user;
        this.sessionId = sessionId;
    }

    public void merge(TriggerStateResponse responseToMergeWith) {
        this.getStates().putAll(responseToMergeWith.getStates());
        this.setErrorMessage(this.getErrorMessage() + responseToMergeWith.getErrorMessage());
        if (this.getUser() == null) {
            this.setUser(responseToMergeWith.getUser());
        }
        if (this.getSessionId().isEmpty()) {
            this.setSessionId(responseToMergeWith.getSessionId());
        }
    }

    public Map<BigInteger, TriggerState> getStates() {
        return this.states;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public StubUser getUser() {
        return this.user;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setStates(Map<BigInteger, TriggerState> states) {
        this.states = states;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setUser(StubUser user) {
        this.user = user;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}

