/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.message;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.content.Content;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.helper.StorableUtils;

@Entity
@JsonFilter(value="reportWorkerFilter_Message")
public class Message
extends AbstractStorable
implements Serializable {
    private static final long serialVersionUID = -3078836082686301236L;
    private String text;
    private transient Content<?> content;
    private File file;
    private Map<String, Object> connectionProperties = new ConnectionProperties();
    private Map<String, Object> headers = Maps.newHashMapWithExpectedSize((int)10);
    private Map<String, String> transportProperties = Maps.newHashMapWithExpectedSize((int)10);
    private String failedMessage;

    public Message() {
    }

    public Message(String text) {
        this.text = text;
    }

    public Message(File file) {
        this.file = file;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @JsonIgnore
    public Content<?> getContent() {
        return this.content;
    }

    public void setContent(Content<?> content) {
        this.content = content;
    }

    public void addConnectionProperty(String key, Object object) {
        this.connectionProperties.put(key, object);
    }

    public Map<String, Object> getConnectionProperties() {
        return this.connectionProperties;
    }

    public <T> T getConnectionPropertiesParameter(String paramName) {
        return (T)this.connectionProperties.get(paramName);
    }

    protected void setConnectionProperties(Map<String, Object> connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void fillConnectionProperties(Map<String, Object> connectionProperties) {
        for (Map.Entry<String, Object> entry : connectionProperties.entrySet()) {
            if (this.getConnectionProperties().containsKey(entry.getKey()) && this.getConnectionProperties().get(entry.getKey()).equals("")) {
                this.getConnectionProperties().put(entry.getKey(), entry.getValue());
                continue;
            }
            this.getConnectionProperties().computeIfAbsent(entry.getKey(), s -> entry.getValue());
        }
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    protected void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void fillHeaders(Map<String, String> headers) {
        StorableUtils.fillMap(this.getHeaders(), headers);
    }

    public void fillHeaders(Map<String, Object> sourceMap, String key) {
        if (sourceMap.containsKey(key)) {
            this.fillHeaders((Map)sourceMap.get(key));
        }
    }

    public void convertAndSetHeaders(Map<String, Object> sourceHeaders) {
        this.headers.clear();
        sourceHeaders.forEach((key, value) -> this.convertAndAddHeader((String)key, value));
    }

    public void convertAndSetHeaders(Map<String, Object> sourceHeaders, List<String> excludeHeaders) {
        if (excludeHeaders == null || excludeHeaders.isEmpty()) {
            this.convertAndSetHeaders(sourceHeaders);
        } else {
            this.headers.clear();
            sourceHeaders.forEach((key, value) -> {
                if (!excludeHeaders.contains(key)) {
                    this.convertAndAddHeader((String)key, value);
                }
            });
        }
    }

    private void convertAndAddHeader(String key, Object value) {
        if (value instanceof byte[]) {
            this.headers.put(key, new String((byte[])value, StandardCharsets.UTF_8).replace('\u0000', ' '));
        } else if (value instanceof ByteArrayInputStream) {
            ByteArrayInputStream bais = (ByteArrayInputStream)value;
            int n = bais.available();
            if (n > 0) {
                byte[] bytes = new byte[n];
                int cnt = bais.read(bytes, 0, n);
                this.headers.put(key, new String(bytes, 0, cnt, StandardCharsets.UTF_8));
            }
        } else if (value instanceof List) {
            this.headers.put(key, value);
        } else {
            this.headers.put(key, Objects.toString(value, "").replace('\u0000', ' '));
        }
    }

    public void convertAndSetMultiHeaders(Map<String, List<String>> headers) {
        this.headers.clear();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            this.headers.put(entry.getKey(), Objects.toString(entry.getValue().get(0), "").replace('\u0000', ' '));
        }
    }

    public Map<String, String> getTransportProperties() {
        return this.transportProperties;
    }

    protected void setTransportProperties(Map<String, String> transportProperties) {
        this.transportProperties = transportProperties;
    }

    public void fillTransportProperties(Map<String, String> transportProperties) {
        StorableUtils.fillMap(this.getTransportProperties(), transportProperties);
    }

    public void connection2TransportProperties(Map<String, Object> connectionProperties) {
        this.transportProperties.clear();
        for (Map.Entry<String, Object> entry : connectionProperties.entrySet()) {
            this.transportProperties.put(entry.getKey(), Objects.toString(entry.getValue(), ""));
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFailedMessage() {
        return this.failedMessage;
    }

    public void setFailedMessage(String failedMessage) {
        this.failedMessage = failedMessage;
    }
}

