/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.server;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.ServerObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.eci.AbstractEciConfigurable;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.helper.ServerUtils;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=ServerHB.class)
public class ServerHB
extends AbstractEciConfigurable
implements Server {
    private static final long serialVersionUID = 20240812L;
    private String url;
    @JsonProperty(value="type")
    private String className = this.getClass().getName();
    private Collection<OutboundTransportConfiguration> outbounds = Lists.newArrayList();
    private Collection<InboundTransportConfiguration> inbounds = Lists.newArrayList();
    private BigInteger projectId;

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public ConnectionProperties calculate(@Nonnull System receiver, @Nonnull TransportConfiguration configuration, @Nonnull Message message, Template template) throws TransportException {
        return ServerUtils.calculate(this, receiver, configuration, message, template);
    }

    @Override
    public ConnectionProperties calculate(@Nonnull System receiver, @Nonnull TransportConfiguration configuration, @Nonnull Message message, Template template, InstanceContext instanceContext) throws TransportException {
        return ServerUtils.calculate(this, receiver, configuration, message, template, instanceContext);
    }

    @Override
    @Nonnull
    public OutboundTransportConfiguration getOutbound(System system, String type) {
        return Objects.requireNonNull(TxExecutor.executeUnchecked(() -> {
            ServerObjectManager serverObjectManager = ServerObjectManager.INSTANCE;
            Server server = this;
            OutboundTransportConfiguration result = serverObjectManager.getOutbound(server, system, type);
            if (result == null) {
                server = ServerUtils.syncOutbounds(server, system);
                result = serverObjectManager.getOutbound(server, system, type);
            }
            return result;
        }, TxExecutor.readOnlyTransaction()), String.format("No OutboundTransportConfiguration for system [%s] and type [%s] found", system, type));
    }

    @Override
    public Collection<OutboundTransportConfiguration> getOutbounds(System system) {
        return TxExecutor.executeUnchecked(() -> {
            Server server = ServerUtils.syncOutbounds((Server)this, system);
            return ImmutableList.copyOf(ServerObjectManager.INSTANCE.getOutbounds(server, system));
        }, TxExecutor.readOnlyTransaction());
    }

    @Override
    public Collection<OutboundTransportConfiguration> getOutbounds() {
        return this.outbounds;
    }

    protected void setOutbounds(Collection<OutboundTransportConfiguration> outbounds) {
        this.outbounds = outbounds;
    }

    @Override
    public void fillOutbounds(Collection<OutboundTransportConfiguration> outbounds) {
        StorableUtils.fillCollection(this.outbounds, outbounds);
    }

    @Override
    @JsonSerialize(using=IdSerializer.class)
    public Storable getParent() {
        return super.getParent();
    }

    @Override
    public InboundTransportConfiguration getInbound(System system, TransportConfiguration configuration) {
        return TxExecutor.executeUnchecked(() -> {
            ServerObjectManager serverObjectManager = ServerObjectManager.INSTANCE;
            Server server = this;
            InboundTransportConfiguration result = serverObjectManager.getInbound(server, configuration);
            if (result == null) {
                server = ServerUtils.syncInbounds(server, system);
                result = serverObjectManager.getInbound(server, configuration);
            }
            return result;
        }, TxExecutor.readOnlyTransaction());
    }

    @Override
    public InboundTransportConfiguration getInboundTransportConfiguration(TransportConfiguration configuration) {
        return TxExecutor.executeUnchecked(() -> {
            ServerHB server = this;
            return ServerObjectManager.INSTANCE.getInbound(server, configuration);
        }, TxExecutor.readOnlyTransaction());
    }

    @Override
    public Collection<InboundTransportConfiguration> getInbounds(System system) {
        return TxExecutor.executeUnchecked(() -> {
            Server server = ServerUtils.syncInbounds((Server)this, system);
            return ImmutableList.copyOf(ServerObjectManager.INSTANCE.getInbounds(server, system));
        }, TxExecutor.readOnlyTransaction());
    }

    @Override
    public Collection<InboundTransportConfiguration> getInbounds() {
        return this.inbounds;
    }

    protected void setInbounds(Collection<InboundTransportConfiguration> inbounds) {
        this.inbounds = inbounds;
    }

    @Override
    public void fillInbounds(Collection<InboundTransportConfiguration> inbounds) {
        StorableUtils.fillCollection(this.inbounds, inbounds);
    }

    @Override
    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }

    @Override
    public void setConfigurationProperties(Configuration configuration, Map<String, String> properties) {
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    protected ObjectManager getManager() {
        return CoreObjectManager.getInstance().getManager(Server.class);
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        super.performPostImportActions(projectId, sessionId);
        this.setProjectId(projectId);
        for (OutboundTransportConfiguration outbound : this.getOutbounds()) {
            outbound.performPostImportActions(projectId, sessionId);
        }
        for (InboundTransportConfiguration inbound : this.getInbounds()) {
            inbound.performPostImportActions(projectId, sessionId);
        }
    }

    @Override
    public void unbindEntityWithHierarchy() {
        this.setEciParameters(null, null);
        for (InboundTransportConfiguration itc : this.getInbounds()) {
            itc.unbindEntityWithHierarchy();
        }
        for (OutboundTransportConfiguration otc : this.getOutbounds()) {
            otc.unbindEntityWithHierarchy();
        }
    }

    @Override
    public void upStorableVersion() {
        super.upStorableVersion();
        for (OutboundTransportConfiguration outbound : this.getOutbounds()) {
            outbound.upStorableVersion();
        }
        for (InboundTransportConfiguration inbound : this.getInbounds()) {
            inbound.upStorableVersion();
        }
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        this.outbounds.forEach(outbound -> outbound.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
        this.inbounds.forEach(inbound -> inbound.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
    }

    @Override
    public BigInteger getProjectId() {
        return this.projectId;
    }
}

