/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.step;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.Transient;
import java.math.BigInteger;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.container.StepContainer;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.step.AbstractCallChainStep;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.regenerator.KeysRegeneratable;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.ei.deserialize.DeserializedEntitiesCache;
import org.qubership.automation.itf.core.util.ei.deserialize.SituationDeserializer;
import org.qubership.automation.itf.core.util.ei.deserialize.SituationsSetDeserializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdsListSerializer;

@Entity
@JsonIgnoreProperties(ignoreUnknown=true, value={"hibernateLazyInitializer", "handler"})
public class SituationStep
extends AbstractCallChainStep
implements KeysRegeneratable {
    private static final long serialVersionUID = 20240812L;
    @JsonProperty(value="type")
    public static final String TYPE = "situationStep";
    private Situation situation;
    private Set<Situation> endSituations = Sets.newHashSetWithExpectedSize((int)2);
    private Set<Situation> exceptionalSituations = Sets.newHashSetWithExpectedSize((int)5);
    private boolean waitAllEndSituations;
    private boolean retryOnFail = false;
    private long retryTimeout;
    private String retryTimeoutUnit = TimeUnit.SECONDS.toString();
    private int validationMaxAttempts;
    private long validationMaxTime;
    private String validationUnitMaxTime = TimeUnit.SECONDS.toString();

    public SituationStep() {
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only StepContainer objects are here")
    public SituationStep(Storable parent) {
        this.setParent(parent);
        ((StepContainer)parent).getSteps().add(this);
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public CallChain getParent() {
        return (CallChain)super.getParent();
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=CallChain.class)
    public void setParent(CallChain parent) {
        super.setParent(parent);
    }

    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public Situation getSituation() {
        return this.situation;
    }

    @JsonDeserialize(using=SituationDeserializer.class)
    public void setSituation(Situation situation) {
        this.situation = situation;
    }

    @RefCopy
    @JsonSerialize(using=IdsListSerializer.class)
    public Set<Situation> getEndSituations() {
        return this.endSituations;
    }

    @JsonDeserialize(using=SituationsSetDeserializer.class)
    public void setEndSituations(Set<Situation> endSituations) {
        this.endSituations = endSituations;
    }

    @RefCopy
    @JsonSerialize(using=IdsListSerializer.class)
    public Set<Situation> getExceptionalSituations() {
        return this.exceptionalSituations;
    }

    @JsonDeserialize(using=SituationsSetDeserializer.class)
    public void setExceptionalSituations(Set<Situation> exceptionalSituations) {
        this.exceptionalSituations = exceptionalSituations;
    }

    @RefCopy
    public boolean getWaitAllEndSituations() {
        return this.waitAllEndSituations;
    }

    public void setWaitAllEndSituations(boolean waitAllEndSituations) {
        this.waitAllEndSituations = waitAllEndSituations;
    }

    @Override
    public Mep getMep() {
        return this.situation != null ? this.situation.getMep() : null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SituationStep{situation=").append(this.situation);
        for (Situation situation : this.endSituations) {
            builder.append(", endSituation=").append(situation);
        }
        return builder.append('}').toString();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean isRetryOnFail() {
        return this.retryOnFail;
    }

    public void setRetryOnFail(boolean retryOnFail) {
        this.retryOnFail = retryOnFail;
    }

    public long getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public String getRetryTimeoutUnit() {
        return this.retryTimeoutUnit;
    }

    public void setRetryTimeoutUnit(String retryTimeoutUnit) {
        this.retryTimeoutUnit = SituationStep.checkUnit(retryTimeoutUnit);
    }

    @Transient
    @JsonIgnore
    public TimeUnit retrieveRetryTimeoutUnit() {
        return SituationStep.convertToTimeUnit(this.retryTimeoutUnit);
    }

    public int getValidationMaxAttempts() {
        return this.validationMaxAttempts;
    }

    public void setValidationMaxAttempts(int validationMaxAttempts) {
        this.validationMaxAttempts = validationMaxAttempts;
    }

    public long getValidationMaxTime() {
        return this.validationMaxTime;
    }

    public void setValidationMaxTime(long validationMaxTime) {
        this.validationMaxTime = validationMaxTime;
    }

    public String getValidationUnitMaxTime() {
        return this.validationUnitMaxTime;
    }

    public void setValidationUnitMaxTime(String validationUnitMaxTime) {
        this.validationUnitMaxTime = SituationStep.checkUnit(validationUnitMaxTime);
    }

    @Transient
    @JsonIgnore
    public TimeUnit retrieveValidationUnitMaxTime() {
        return SituationStep.convertToTimeUnit(this.validationUnitMaxTime);
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        this.setLastOrderToImportedStep((CallChain)DeserializedEntitiesCache.getInstance().getCacheBySessionId(sessionId).getById((BigInteger)this.getParent().getID()));
        super.performPostImportActions(projectId, sessionId);
        if (this.getSituation() != null) {
            this.getSituation().performPostImportActions(projectId, sessionId);
        }
        for (Situation endSituation : this.getEndSituations()) {
            endSituation.performPostImportActions(projectId, sessionId);
        }
        for (Situation exceptionalSituation : this.getExceptionalSituations()) {
            exceptionalSituation.performPostImportActions(projectId, sessionId);
        }
    }
}

