/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.system.operation;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.parser.OperationParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.annotation.NoCopy;
import org.qubership.automation.itf.core.util.annotation.ProduceNewObject;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.annotation.RefCopyAsNewObject;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.KeyDefinitionProvider;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=Operation.class)
public class Operation
extends AbstractStorable
implements ParsingRuleProvider,
KeyDefinitionProvider,
TemplateProvider {
    private static final long serialVersionUID = 20240812L;
    private TransportConfiguration transport;
    private String operationDefinitionKey;
    private String outgoingContextKeyDefinition;
    private String incomingContextKeyDefinition;
    private Set<OperationParsingRule> operationParsingRules = Sets.newHashSetWithExpectedSize((int)10);
    private Set<OperationTemplate> operationTemplates = Sets.newHashSetWithExpectedSize((int)50);
    private Set<Situation> situations = Sets.newHashSetWithExpectedSize((int)20);
    private Situation errorInboundSituation;
    private Situation defaultInboundSituation;
    BigInteger projectId;

    public Operation() {
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only System objects are here")
    public Operation(Storable parent) {
        this.setParent(parent);
        this.setProjectId(parent.getProjectId());
        ((System)parent).getOperations().add(this);
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public System getParent() {
        return (System)super.getParent();
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=System.class)
    public void setParent(System parent) {
        super.setParent(parent);
    }

    @RefCopyAsNewObject
    @JsonSerialize(using=IdSerializer.class)
    public TransportConfiguration getTransport() {
        return this.transport;
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=TransportConfiguration.class)
    public void setTransport(TransportConfiguration transport) {
        this.transport = transport;
    }

    public void fillSituations(Collection<Situation> situations) {
        StorableUtils.fillCollection(this.getSituations(), situations);
    }

    @Override
    @ProduceNewObject
    public Object getNaturalId() {
        return super.getNaturalId();
    }

    @JsonIgnore
    public Mep getMep() {
        if (this.transport != null && this.transport.getMep() != null) {
            return this.transport.getMep();
        }
        if (this.getName().contains("Callback")) {
            return Mep.OUTBOUND_REQUEST_ASYNCHRONOUS;
        }
        return Mep.INBOUND_REQUEST_ASYNCHRONOUS;
    }

    @NoCopy
    @JsonIgnore
    public Situation getDefaultIfInbound() {
        if (this.getMep().isInbound() && this.getMep().isRequest()) {
            if (this.defaultInboundSituation == null) {
                this.createDefault();
            }
            return this.defaultInboundSituation;
        }
        return null;
    }

    @NoCopy
    @JsonIgnore
    public Situation getDefaultInboundSituation() {
        return this.defaultInboundSituation;
    }

    @NoCopy
    @JsonIgnore
    public void setDefaultInboundSituation(Situation defaultInboundSituation) {
        this.defaultInboundSituation = defaultInboundSituation;
    }

    @Override
    @JsonIgnore
    public Set<ParsingRule> returnParsingRules() {
        return this.operationParsingRules.stream().map(ParsingRule.class::cast).collect(Collectors.toSet());
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only OperationParsingRule objects are here")
    public void addParsingRule(ParsingRule parsingRule) {
        this.operationParsingRules.add((OperationParsingRule)parsingRule);
    }

    @Override
    public void removeParsingRule(ParsingRule parsingRule) {
        this.operationParsingRules.remove(parsingRule);
    }

    @Override
    @JsonIgnore
    public Set<Template> returnTemplates() {
        return this.operationTemplates.stream().map(Template.class::cast).collect(Collectors.toSet());
    }

    @Override
    public Storable returnSimpleParent() {
        Storable system = super.returnSimpleParent();
        if (this.getTransport() != null) {
            ((System)system).getTransports().add(this.getTransport());
        }
        return system;
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        super.performPostImportActions(projectId, sessionId);
        if (this.getTransport() != null) {
            this.getTransport().performPostImportActions(projectId, sessionId);
        }
        for (OperationParsingRule parsingRule : this.getOperationParsingRules()) {
            parsingRule.performPostImportActions(projectId, sessionId);
        }
        for (OperationTemplate template : this.getOperationTemplates()) {
            template.performPostImportActions(projectId, sessionId);
        }
        for (Situation situation : this.getSituations()) {
            situation.performPostImportActions(projectId, sessionId);
            if (this.getDefaultInboundSituation() != null && this.getDefaultInboundSituation().getID().equals(situation.getID())) {
                this.setDefaultInboundSituation(situation);
            }
            if (this.getErrorInboundSituation() == null || !this.getErrorInboundSituation().getID().equals(situation.getID())) continue;
            this.setErrorInboundSituation(situation);
        }
    }

    private void createDefault() {
        TxExecutor.executeUnchecked(() -> {
            this.defaultInboundSituation = CoreObjectManager.getInstance().getManager(Situation.class).create();
            this.defaultInboundSituation.setName(String.format("[ *** DEFAULT (autocreated) *** ] [%s] receives [%s] request", this.getParent().getName(), this.getName()));
            this.defaultInboundSituation.store();
            this.store();
            return null;
        }, TxExecutor.nestedWritableTransaction());
    }

    @NoCopy
    @JsonIgnore
    public Situation getErrorInboundSituation() {
        return this.errorInboundSituation;
    }

    @NoCopy
    @JsonIgnore
    public void setErrorInboundSituation(Situation errorInboundSituation) {
        this.errorInboundSituation = errorInboundSituation;
    }

    @Override
    @JsonIgnore
    public Storable getExtendsParameters() {
        return this.getTransport();
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        this.getOperationParsingRules().forEach(parsingRule -> parsingRule.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
        this.getOperationTemplates().forEach(template -> template.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
        this.getSituations().forEach(situation -> situation.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
    }

    public String getOperationDefinitionKey() {
        return this.operationDefinitionKey;
    }

    @Override
    public String getOutgoingContextKeyDefinition() {
        return this.outgoingContextKeyDefinition;
    }

    @Override
    public String getIncomingContextKeyDefinition() {
        return this.incomingContextKeyDefinition;
    }

    public Set<OperationParsingRule> getOperationParsingRules() {
        return this.operationParsingRules;
    }

    public Set<OperationTemplate> getOperationTemplates() {
        return this.operationTemplates;
    }

    public Set<Situation> getSituations() {
        return this.situations;
    }

    @Override
    public BigInteger getProjectId() {
        return this.projectId;
    }

    public void setOperationDefinitionKey(String operationDefinitionKey) {
        this.operationDefinitionKey = operationDefinitionKey;
    }

    @Override
    public void setOutgoingContextKeyDefinition(String outgoingContextKeyDefinition) {
        this.outgoingContextKeyDefinition = outgoingContextKeyDefinition;
    }

    @Override
    public void setIncomingContextKeyDefinition(String incomingContextKeyDefinition) {
        this.incomingContextKeyDefinition = incomingContextKeyDefinition;
    }

    public void setOperationParsingRules(Set<OperationParsingRule> operationParsingRules) {
        this.operationParsingRules = operationParsingRules;
    }

    public void setOperationTemplates(Set<OperationTemplate> operationTemplates) {
        this.operationTemplates = operationTemplates;
    }

    public void setSituations(Set<Situation> situations) {
        this.situations = situations;
    }

    @Override
    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }
}

