/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.stub.fast;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.automation.itf.core.stub.fast.FastResponseConfig;
import org.qubership.automation.itf.core.stub.fast.FastStubsTreeView;
import org.qubership.automation.itf.core.stub.fast.StubEndpointConfig;
import org.qubership.automation.itf.core.stub.fast.TransportConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FastResponseConfigsHolder {
    INSTANCE;

    private static final Logger log;
    private static final ObjectMapper objectMapper;
    private final ConcurrentHashMap<String, StubEndpointConfig> cfg = new ConcurrentHashMap();

    public StubEndpointConfig getConfig(String projectUuid, String transportType, String configuredEndpoint) {
        return this.cfg.get(projectUuid + "/" + transportType + "/" + configuredEndpoint);
    }

    public void putConfig(String projectUuid, String transportType, StubEndpointConfig config) {
        this.cfg.put(projectUuid + "/" + transportType + "/" + config.getConfiguredEndpoint(), config);
    }

    public void resetConfigByKey(String key) {
        this.cfg.entrySet().removeIf(entry -> ((String)entry.getKey()).equals(key));
    }

    public void resetConfigForProject(String projectUuid) {
        this.cfg.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(projectUuid));
    }

    public void loadFromFile(String uuidFromInfo, File savedFile) {
        try {
            FastResponseConfig fastResponseConfig = (FastResponseConfig)objectMapper.readValue(savedFile, FastResponseConfig.class);
            if (uuidFromInfo.equals(fastResponseConfig.getProjectUuid())) {
                for (TransportConfig transportConfig : fastResponseConfig.getTransportConfigs()) {
                    for (StubEndpointConfig config : transportConfig.getEndpoints()) {
                        this.putConfig(fastResponseConfig.getProjectUuid(), transportConfig.getTransportType().name().toUpperCase(), config);
                    }
                }
                log.info("Config is loaded for {} project from file {}", (Object)fastResponseConfig.getProjectUuid(), (Object)savedFile.getName());
            } else {
                log.warn("Project UUID mismatch: {} vs {} (in file); config is not loaded!", (Object)uuidFromInfo, (Object)fastResponseConfig.getProjectUuid());
            }
        }
        catch (IOException ex) {
            log.error("Error while post-processing of the file {} [path: {}]", new Object[]{savedFile.getName(), savedFile.getPath(), ex});
        }
    }

    public List<FastStubsTreeView> getEndpoints(UUID projectUuid) {
        ArrayList<FastStubsTreeView> endpoints = new ArrayList<FastStubsTreeView>();
        Pattern restPattern = Pattern.compile(String.format("%s\\/%s\\/.*", new Object[]{projectUuid, StubEndpointConfig.TransportTypes.REST}));
        Pattern soapPattern = Pattern.compile(String.format("%s\\/%s\\/.*", new Object[]{projectUuid, StubEndpointConfig.TransportTypes.SOAP}));
        for (String key : this.cfg.keySet()) {
            Matcher restMatcher = restPattern.matcher(key);
            if (restMatcher.find()) {
                endpoints.add(this.createFastStubsTreeView(this.cfg.get(key), StubEndpointConfig.TransportTypes.REST));
                continue;
            }
            Matcher soapMatcher = soapPattern.matcher(key);
            if (!soapMatcher.find()) continue;
            endpoints.add(this.createFastStubsTreeView(this.cfg.get(key), StubEndpointConfig.TransportTypes.SOAP));
        }
        return endpoints;
    }

    private FastStubsTreeView createFastStubsTreeView(StubEndpointConfig stubEndpointConfig, StubEndpointConfig.TransportTypes transportType) {
        return new FastStubsTreeView(stubEndpointConfig.getConfiguredEndpoint(), transportType);
    }

    static {
        log = LoggerFactory.getLogger(FastResponseConfigsHolder.class);
        objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

