/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.copier;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.common.LabeledStorable;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.parser.OperationParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.annotation.NoCopy;
import org.qubership.automation.itf.core.util.annotation.OperationRefCopyAsNewObject;
import org.qubership.automation.itf.core.util.annotation.ProduceNewObject;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.annotation.RefCopyAsNewObject;
import org.qubership.automation.itf.core.util.annotation.TemplateRefCopyAsNewObject;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.copier.OriginalCopyMap;
import org.qubership.automation.itf.core.util.exception.CopyException;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.qubership.automation.itf.core.util.services.CoreServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class StorableCopier {
    private static final Logger log = LoggerFactory.getLogger(StorableCopier.class);
    private static final String USECASE1 = "UC.1";
    private static final String USECASE2 = "UC.2";
    private static final String USECASE3 = "UC.3";
    private static final String USECASE4 = "UC.4";
    private static final String USECASE5 = "UC.5";
    private static final String USECASE6 = "UC.6";
    private static final Map<String, Boolean> mapCopyFlag = new HashMap<String, Boolean>();
    private final String sessionId;

    public StorableCopier(String sessionId) {
        this.sessionId = sessionId;
    }

    public static boolean getValueMapCopyFlag(String key) {
        return mapCopyFlag.get(key);
    }

    public static void setKeyAndValueMapCopyFlag(String key, boolean value) {
        mapCopyFlag.put(key, value);
    }

    private static Method getSetOrFillMethod(PropertyDescriptor descriptor, Class owner) {
        Method method = descriptor.getWriteMethod();
        if (method == null) {
            String methodName = "fill" + StringUtils.capitalize((String)descriptor.getName());
            try {
                method = owner.getMethod(methodName, descriptor.getPropertyType());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }

    private static void copyReferenceOrValue(PropertyDescriptor descriptor, Storable source, Storable dest) throws CopyException {
        try {
            String value = descriptor.getReadMethod().isAnnotationPresent(ProduceNewObject.class) ? source.getID().toString() : descriptor.getReadMethod().invoke((Object)source, new Object[0]);
            StorableCopier.getSetOrFillMethod(descriptor, dest.getClass()).invoke((Object)dest, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new CopyException(String.format("Error while copying property %s from %s to %s", descriptor.getName(), source, dest), e);
        }
    }

    private static Map produceNewMap(Map ethalon) {
        if (ethalon.getClass().getName().contains("java.util")) {
            try {
                return (Map)ethalon.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                return StorableCopier.produceBasicMap(ethalon);
            }
        }
        return StorableCopier.produceBasicMap(ethalon);
    }

    private static Map produceBasicMap(Map ethalon) {
        return Maps.newHashMapWithExpectedSize((int)ethalon.size());
    }

    private static Collection produceNewCollection(Collection ethalon) {
        if (ethalon.getClass().getName().contains("java.util")) {
            try {
                return (Collection)ethalon.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                return StorableCopier.produceBasicCollection(ethalon);
            }
        }
        return StorableCopier.produceBasicCollection(ethalon);
    }

    private static Collection produceBasicCollection(Collection ethalon) {
        if (Set.class.isAssignableFrom(ethalon.getClass())) {
            return Sets.newHashSetWithExpectedSize((int)ethalon.size());
        }
        if (Queue.class.isAssignableFrom(ethalon.getClass())) {
            return Lists.newLinkedList();
        }
        return Lists.newArrayListWithExpectedSize((int)ethalon.size());
    }

    private static void copyCollection(PropertyDescriptor descriptor, Storable source, Storable dest) throws CopyException {
        try {
            Collection collection = (Collection)descriptor.getReadMethod().invoke((Object)source, new Object[0]);
            Collection newCollection = StorableCopier.produceNewCollection(collection);
            newCollection.addAll(collection);
            StorableCopier.getSetOrFillMethod(descriptor, dest.getClass()).invoke((Object)dest, newCollection);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CopyException(String.format("Error while copying property %s from %s to %s", descriptor.getName(), source, dest), e);
        }
    }

    private static void copyMap(PropertyDescriptor descriptor, Storable source, Storable dest) throws CopyException {
        try {
            Map newCollection;
            Map map = (Map)descriptor.getReadMethod().invoke((Object)source, new Object[0]);
            Map map2 = newCollection = map == null ? new HashMap() : StorableCopier.produceNewMap(map);
            if (map != null) {
                newCollection.putAll(map);
            }
            StorableCopier.getSetOrFillMethod(descriptor, dest.getClass()).invoke((Object)dest, newCollection);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CopyException(String.format("Error while copying property %s from %s to %s", descriptor.getName(), source, dest), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Casted objects have proper types")
    public Storable copy(Storable storable, Storable destination, String projectId, String prefix) throws CopyException {
        Storable newStorable;
        String propertyName = CoreObjectManager.getInstance().getManager(destination.getClass()).acceptsTo(storable);
        if (propertyName == null) {
            throw new CopyException(String.format("Destination %s cannot accept child %s", destination, storable));
        }
        boolean sameParent = Objects.equals(storable.getParent(), destination);
        String useCaseForTemplate = this.getUseCase(storable, destination, sameParent);
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(destination.getClass(), (String)propertyName);
        if (Collection.class.isAssignableFrom(descriptor.getReadMethod().getReturnType())) {
            try {
                Collection collection = (Collection)descriptor.getReadMethod().invoke((Object)destination, new Object[0]);
                newStorable = this.createCopy(storable, destination, prefix, sameParent, useCaseForTemplate);
                collection.add(newStorable);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                OriginalCopyMap.getInstance().clear(this.sessionId);
                throw new CopyException(String.format("Error while adding copy of %s to parent %s", storable, destination));
            }
        }
        if (!descriptor.getReadMethod().getReturnType().isAssignableFrom(storable.getClass())) {
            OriginalCopyMap.getInstance().clear(this.sessionId);
            throw new CopyException(String.format("Parent %s cannot accept %s", destination, storable));
        }
        if (descriptor.getWriteMethod() == null) {
            OriginalCopyMap.getInstance().clear(this.sessionId);
            throw new CopyException(String.format("Property %s is read-only at %s", descriptor.getName(), destination));
        }
        try {
            newStorable = this.createCopy(storable, destination, prefix, sameParent, "");
            descriptor.getWriteMethod().invoke((Object)destination, newStorable);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OriginalCopyMap.getInstance().clear(this.sessionId);
            throw new CopyException(String.format("Error while setting copy of %s as child to parent %s", storable, destination));
        }
        if (newStorable instanceof Template) {
            ((Template)newStorable).setParent((TemplateProvider)destination);
        } else if (newStorable instanceof ParsingRule) {
            ((ParsingRule)newStorable).setParent((ParsingRuleProvider)destination);
        } else if (newStorable instanceof TransportConfiguration) {
            ((TransportConfiguration)newStorable).setParent((System)destination);
        } else {
            newStorable.setParent(destination);
        }
        if (prefix.equals("copy") && !useCaseForTemplate.isEmpty()) {
            this.postActionsForUpdateParent(newStorable, destination, useCaseForTemplate);
            this.postActionsForUpdateTriggerOnSituation(newStorable, useCaseForTemplate);
        }
        newStorable.store();
        newStorable.performPostCopyActions(Boolean.parseBoolean(CoreServices.getProjectSettingsService().get(projectId, "copyObjects.setStatusOff", "false")));
        return newStorable;
    }

    private Storable createCopy(Storable storable, Storable destination, String prefix, boolean sameParent, String useCaseForTemplate) throws CopyException {
        PropertyDescriptor[] descriptors;
        Storable newStorable;
        try {
            newStorable = Iterables.tryFind(Arrays.asList(storable.getClass().getInterfaces()), input -> input.getName().equals("org.hibernate.proxy.HibernateProxy")).isPresent() ? storable.getClass().getSuperclass().asSubclass(Storable.class).newInstance() : (Storable)storable.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CopyException(String.format("Error creating copy of %s", storable));
        }
        for (PropertyDescriptor descriptor : descriptors = BeanUtils.getPropertyDescriptors(newStorable.getClass())) {
            if (descriptor.getReadMethod() == null || StorableCopier.getSetOrFillMethod(descriptor, newStorable.getClass()) == null || descriptor.getReadMethod().isAnnotationPresent(NoCopy.class)) continue;
            if (Storable.class.isAssignableFrom(descriptor.getReadMethod().getReturnType())) {
                if (descriptor.getReadMethod().isAnnotationPresent(RefCopyAsNewObject.class)) {
                    if (sameParent) {
                        StorableCopier.copyReferenceOrValue(descriptor, storable, newStorable);
                        continue;
                    }
                    this.copyReferenceAsNewEntity(descriptor, storable, destination, newStorable, prefix, useCaseForTemplate);
                    continue;
                }
                if (descriptor.getReadMethod().isAnnotationPresent(RefCopy.class)) {
                    StorableCopier.copyReferenceOrValue(descriptor, storable, newStorable);
                    continue;
                }
                if (descriptor.getReadMethod().isAnnotationPresent(OperationRefCopyAsNewObject.class)) {
                    this.forOperation_copyReferenceAsNewEntity(descriptor, storable, destination, newStorable, prefix, useCaseForTemplate);
                    continue;
                }
                if (descriptor.getReadMethod().isAnnotationPresent(TemplateRefCopyAsNewObject.class)) {
                    this.forTemplate_copyReferenceAsNewEntity(descriptor, storable, destination, newStorable, prefix, useCaseForTemplate);
                    continue;
                }
                this.copyChild(descriptor, storable, newStorable, prefix, useCaseForTemplate);
                continue;
            }
            if (Collection.class.isAssignableFrom(descriptor.getReadMethod().getReturnType())) {
                if (!(descriptor.getReadMethod().getGenericReturnType() instanceof ParameterizedType)) continue;
                Type[] types = ((ParameterizedType)descriptor.getReadMethod().getGenericReturnType()).getActualTypeArguments();
                if (types != null && types.length > 0) {
                    if (types[0] instanceof Class) {
                        if (Storable.class.isAssignableFrom((Class)types[0]) && !descriptor.getReadMethod().isAnnotationPresent(RefCopy.class)) {
                            this.copyChildCollection(descriptor, storable, newStorable, prefix, useCaseForTemplate);
                            continue;
                        }
                        StorableCopier.copyCollection(descriptor, storable, newStorable);
                        continue;
                    }
                    if (types[0] instanceof ParameterizedType) {
                        if (Storable.class.isAssignableFrom((Class)((ParameterizedType)types[0]).getRawType()) && !descriptor.getReadMethod().isAnnotationPresent(RefCopy.class)) {
                            this.copyChildCollection(descriptor, storable, newStorable, prefix, useCaseForTemplate);
                            continue;
                        }
                        StorableCopier.copyCollection(descriptor, storable, newStorable);
                        continue;
                    }
                    if (types[0] instanceof TypeVariable) {
                        if (((TypeVariable)types[0]).getBounds()[0] instanceof Class && Storable.class.isAssignableFrom((Class)((TypeVariable)types[0]).getBounds()[0]) && !descriptor.getReadMethod().isAnnotationPresent(RefCopy.class)) {
                            this.copyChildCollection(descriptor, storable, newStorable, prefix, useCaseForTemplate);
                            continue;
                        }
                        StorableCopier.copyCollection(descriptor, storable, newStorable);
                        continue;
                    }
                    throw new CopyException("Don't know what to do with property. Please, contact Mockingbird support");
                }
                StorableCopier.copyCollection(descriptor, storable, newStorable);
                continue;
            }
            if (Map.class.isAssignableFrom(descriptor.getReadMethod().getReturnType())) {
                StorableCopier.copyMap(descriptor, storable, newStorable);
                continue;
            }
            StorableCopier.copyReferenceOrValue(descriptor, storable, newStorable);
        }
        if (storable instanceof Map) {
            ((Map)((Object)newStorable)).putAll((Map)((Object)storable));
        }
        newStorable.setName(storable.getName());
        newStorable.setDescription(storable.getDescription());
        if (newStorable instanceof LabeledStorable) {
            LabeledStorable labeledStorable = (LabeledStorable)newStorable;
            labeledStorable.getLabels().clear();
            if (storable instanceof LabeledStorable) {
                LabeledStorable provider = (LabeledStorable)storable;
                labeledStorable.getLabels().addAll(provider.getLabels());
            }
        }
        return newStorable;
    }

    private void copyReferenceAsNewEntity(PropertyDescriptor descriptor, Storable source, Storable dest, Storable entity, String prefix, String useCaseForTemplate) throws CopyException {
        try {
            Storable value = (Storable)descriptor.getReadMethod().invoke((Object)source, new Object[0]);
            if (value == null) {
                return;
            }
            Storable cachedCopiedEntity = OriginalCopyMap.getInstance().get(this.sessionId, value.getID());
            if (cachedCopiedEntity == null) {
                cachedCopiedEntity = this.createCopy(value, dest, prefix, false, useCaseForTemplate);
                cachedCopiedEntity.setParent(dest);
                cachedCopiedEntity.store();
                OriginalCopyMap.getInstance().put(this.sessionId, value.getID(), cachedCopiedEntity);
            }
            StorableCopier.getSetOrFillMethod(descriptor, entity.getClass()).invoke((Object)entity, cachedCopiedEntity);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new CopyException(String.format("Error while copying property %s from %s to %s", descriptor.getName(), source, entity), e);
        }
    }

    private void forOperation_copyReferenceAsNewEntity(PropertyDescriptor descriptor, Storable source, Storable dest, Storable entity, String prefix, String useCaseForTemplate) throws CopyException {
        try {
            Storable value = (Storable)descriptor.getReadMethod().invoke((Object)source, new Object[0]);
            if (value == null) {
                return;
            }
            Storable cachedCopiedEntity = OriginalCopyMap.getInstance().get(this.sessionId, value.getID());
            switch (useCaseForTemplate) {
                case "UC.3": 
                case "UC.6": {
                    TransportConfiguration transportConfiguration = ((Operation)source.getParent().getParent()).getTransport();
                    if (Mep.INBOUND_REQUEST_ASYNCHRONOUS.equals((Object)transportConfiguration.getMep())) {
                        if (cachedCopiedEntity == null) {
                            cachedCopiedEntity = this.createCopy(value, dest.getParent().getParent(), prefix, false, useCaseForTemplate);
                            cachedCopiedEntity.store();
                            StorableCopier.getSetOrFillMethod(descriptor, entity.getClass()).invoke((Object)entity, cachedCopiedEntity);
                            OriginalCopyMap.getInstance().put(this.sessionId, value.getID(), cachedCopiedEntity);
                        }
                        break;
                    }
                    StorableCopier.getSetOrFillMethod(descriptor, entity.getClass()).invoke((Object)entity, value);
                    break;
                }
                default: {
                    StorableCopier.getSetOrFillMethod(descriptor, entity.getClass()).invoke((Object)entity, value);
                    break;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new CopyException(String.format("Error while copying property %s from %s to %s", descriptor.getName(), source, entity), e);
        }
    }

    private void doSpecificActions(PropertyDescriptor descriptor, Storable dest, Storable entity, String prefix, Storable cachedCopiedEntity, Storable value, Storable parent) throws Exception {
        if (cachedCopiedEntity == null) {
            cachedCopiedEntity = this.createCopy(value, dest, prefix, false, "");
            if (parent instanceof Operation) {
                cachedCopiedEntity.setParent(dest.getParent());
            } else if (parent instanceof System) {
                cachedCopiedEntity.setParent(dest.getParent().getParent());
            }
            cachedCopiedEntity.store();
            OriginalCopyMap.getInstance().put(this.sessionId, value.getID(), cachedCopiedEntity);
        }
        StorableCopier.getSetOrFillMethod(descriptor, entity.getClass()).invoke((Object)entity, cachedCopiedEntity);
    }

    private void forTemplate_copyReferenceAsNewEntity(PropertyDescriptor descriptor, Storable source, Storable dest, Storable entity, String prefix, String useCaseForTemplate) throws CopyException {
        try {
            Storable value = (Storable)descriptor.getReadMethod().invoke((Object)source, new Object[0]);
            if (value == null) {
                return;
            }
            Storable cachedCopiedEntity = OriginalCopyMap.getInstance().get(this.sessionId, value.getID());
            boolean copyFlag = StorableCopier.getValueMapCopyFlag(this.sessionId);
            Storable parent = value.getParent();
            switch (useCaseForTemplate) {
                case "UC.1": 
                case "UC.3": 
                case "UC.6": {
                    this.doSpecificActions(descriptor, dest, entity, prefix, cachedCopiedEntity, value, parent);
                    break;
                }
                case "UC.2": 
                case "UC.5": {
                    if (!copyFlag) {
                        if (parent instanceof Operation) {
                            if (cachedCopiedEntity == null) {
                                cachedCopiedEntity = this.createCopy(value, dest, prefix, false, "");
                                cachedCopiedEntity.setParent(dest.getParent());
                                cachedCopiedEntity.store();
                                OriginalCopyMap.getInstance().put(this.sessionId, value.getID(), cachedCopiedEntity);
                            }
                            StorableCopier.getSetOrFillMethod(descriptor, entity.getClass()).invoke((Object)entity, cachedCopiedEntity);
                            break;
                        }
                        if (parent instanceof System) {
                            StorableCopier.copyReferenceOrValue(descriptor, source, entity);
                        }
                        break;
                    }
                    this.doSpecificActions(descriptor, dest, entity, prefix, cachedCopiedEntity, value, parent);
                    break;
                }
                case "UC.4": {
                    if (!copyFlag) {
                        StorableCopier.copyReferenceOrValue(descriptor, source, entity);
                        break;
                    }
                    this.doSpecificActions(descriptor, dest, entity, prefix, cachedCopiedEntity, value, parent);
                    break;
                }
                default: {
                    log.error("Unknown copy/move use case {}!", (Object)useCaseForTemplate);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new CopyException(String.format("Error while copying property %s from %s to %s", descriptor.getName(), source, entity), e);
        }
    }

    private void copyChild(PropertyDescriptor descriptor, Storable source, Storable dest, String prefix, String useCaseForTemplate) throws CopyException {
        try {
            Storable child = (Storable)descriptor.getReadMethod().invoke((Object)source, new Object[0]);
            if (child != null) {
                Storable childCopy = this.createCopy(child, dest, prefix, false, useCaseForTemplate);
                StorableCopier.getSetOrFillMethod(descriptor, dest.getClass()).invoke((Object)dest, childCopy);
                childCopy.setParent(dest);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CopyException(String.format("Error while copying property %s from %s to %s", descriptor.getName(), source, dest), e);
        }
    }

    private void copyChildCollection(PropertyDescriptor descriptor, Storable source, Storable dest, String prefix, String useCaseForTemplate) throws CopyException {
        try {
            Collection collection = (Collection)descriptor.getReadMethod().invoke((Object)source, new Object[0]);
            Collection newCollection = StorableCopier.produceNewCollection(collection);
            for (Storable storable : collection) {
                if (storable == null) continue;
                Storable cachedCopiedEntity = OriginalCopyMap.getInstance().get(this.sessionId, storable.getID());
                if (cachedCopiedEntity == null) {
                    cachedCopiedEntity = this.createCopy(storable, dest, prefix, false, useCaseForTemplate);
                    cachedCopiedEntity.setParent(dest);
                    OriginalCopyMap.getInstance().put(this.sessionId, storable.getID(), cachedCopiedEntity);
                }
                newCollection.add(cachedCopiedEntity);
            }
            StorableCopier.getSetOrFillMethod(descriptor, dest.getClass()).invoke((Object)dest, newCollection);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Exception while child collection {} copying from {} to {}", new Object[]{descriptor.getName(), source, dest, e});
        }
    }

    private String getUseCase(Storable storable, Storable destination, boolean sameParent) {
        String useCaseForTemplate = "";
        if (storable instanceof System) {
            useCaseForTemplate = USECASE1;
        } else if (storable instanceof Operation) {
            useCaseForTemplate = sameParent ? USECASE2 : USECASE3;
        } else if (storable instanceof Situation) {
            boolean sameParentSystem = Objects.equals(storable.getParent().getParent(), destination.getParent());
            useCaseForTemplate = sameParentSystem ? (sameParent ? USECASE4 : USECASE5) : USECASE6;
        }
        return useCaseForTemplate;
    }

    private void postActionsForUpdateParent(Storable newStorable, Storable destination, String useCase) {
        if (newStorable.getID() == null) {
            newStorable.store();
        }
        boolean copyFlag = StorableCopier.getValueMapCopyFlag(this.sessionId);
        switch (useCase) {
            case "UC.1": {
                System copiedSystem = (System)newStorable;
                copiedSystem.getTransports().forEach(transportConfiguration -> transportConfiguration.setParent(copiedSystem));
                for (Operation operation : copiedSystem.getOperations()) {
                    if (operation.getID() == null) {
                        operation.store();
                    }
                    TransportConfiguration transport = this.getTransport(operation, copiedSystem);
                    for (Situation situation : operation.getSituations()) {
                        IntegrationStep integrationStep = situation.getIntegrationStep();
                        if (integrationStep == null) continue;
                        integrationStep.setSender(copiedSystem);
                        if (transport != null) {
                            if (Mep.INBOUND_REQUEST_ASYNCHRONOUS.equals((Object)transport.getMep())) {
                                Operation copyOperation = integrationStep.getOperation();
                                if (copyOperation != null) {
                                    Storable cachedCopiedEntity = OriginalCopyMap.getInstance().get(this.sessionId, copyOperation.getID());
                                    integrationStep.setOperation((Operation)cachedCopiedEntity);
                                }
                            } else {
                                integrationStep.setOperation(operation);
                            }
                        }
                        this.determineTemplateParent(integrationStep.returnStepTemplate(), operation, newStorable);
                    }
                    operation.getOperationTemplates().forEach(operationTemplate -> operationTemplate.setParent(operation));
                    operation.getOperationParsingRules().forEach(operationParsingRule -> operationParsingRule.setParent(operation));
                }
                copiedSystem.getSystemTemplates().forEach(systemTemplate -> systemTemplate.setParent(copiedSystem));
                copiedSystem.getSystemParsingRules().forEach(systemParsingRule -> systemParsingRule.setParent(copiedSystem));
                break;
            }
            case "UC.2": {
                System system = (System)destination;
                Operation operation = (Operation)newStorable;
                TransportConfiguration transport = this.getTransport(operation, system);
                for (Situation situation : operation.getSituations()) {
                    IntegrationStep integrationStep = situation.getIntegrationStep();
                    if (integrationStep == null) continue;
                    if (transport != null && !Mep.INBOUND_REQUEST_ASYNCHRONOUS.equals((Object)transport.getMep())) {
                        integrationStep.setOperation(operation);
                    }
                    this.determineTemplateParent(integrationStep.returnStepTemplate(), operation, system, copyFlag);
                }
                operation.getOperationTemplates().forEach(operationTemplate -> operationTemplate.setParent(operation));
                operation.getOperationParsingRules().forEach(operationParsingRule -> operationParsingRule.setParent(operation));
                break;
            }
            case "UC.3": {
                System system = (System)destination;
                Operation operation = (Operation)newStorable;
                TransportConfiguration transport = this.getTransport(operation, system);
                if (transport != null) {
                    transport.setParent(system);
                    system.addTransport(transport);
                }
                for (Situation situation : operation.getSituations()) {
                    IntegrationStep integrationStep = situation.getIntegrationStep();
                    if (integrationStep == null) continue;
                    this.setReferencesForIntegrationStep(system, operation, transport, integrationStep);
                }
                operation.getOperationParsingRules().forEach(operationParsingRule -> operationParsingRule.setParent(operation));
                operation.getOperationTemplates().forEach(operationTemplate -> operationTemplate.setParent(operation));
                break;
            }
            case "UC.4": {
                Storable system = destination.getParent();
                IntegrationStep integrationStep = ((Situation)newStorable).getIntegrationStep();
                if (!copyFlag || integrationStep == null) break;
                this.determineTemplateParent(integrationStep.returnStepTemplate(), destination, system);
                break;
            }
            case "UC.5": {
                Operation operation = (Operation)destination;
                System system = operation.getParent();
                IntegrationStep integrationStep = ((Situation)newStorable).getIntegrationStep();
                if (integrationStep == null) break;
                TransportConfiguration transport = this.getTransport(operation, system);
                if (transport != null && !Mep.INBOUND_REQUEST_ASYNCHRONOUS.equals((Object)transport.getMep())) {
                    integrationStep.setOperation(operation);
                }
                this.determineTemplateParent(integrationStep.returnStepTemplate(), operation, system, copyFlag);
                break;
            }
            case "UC.6": {
                Operation operation = (Operation)destination;
                System system = operation.getParent();
                IntegrationStep integrationStep = ((Situation)newStorable).getIntegrationStep();
                if (integrationStep == null) break;
                TransportConfiguration transport = this.getTransport(operation, system);
                this.setReferencesForIntegrationStep(system, operation, transport, integrationStep);
                break;
            }
            default: {
                log.error("");
            }
        }
    }

    private void setReferencesForIntegrationStep(System system, Operation operation, TransportConfiguration transport, IntegrationStep integrationStep) {
        integrationStep.setSender(system);
        this.setOperationToStepAccorgingToTransportMep(system, operation, transport, integrationStep);
        this.determineTemplateParent(integrationStep.returnStepTemplate(), operation, system);
    }

    private void setOperationToStepAccorgingToTransportMep(System system, Operation operation, TransportConfiguration transport, IntegrationStep integrationStep) {
        if (transport != null) {
            if (Mep.INBOUND_REQUEST_ASYNCHRONOUS.equals((Object)transport.getMep())) {
                Operation copyOperationOnStep = integrationStep.getOperation();
                if (copyOperationOnStep != null) {
                    copyOperationOnStep.setParent(system);
                    system.addOperation(copyOperationOnStep);
                    TransportConfiguration copyTransport = copyOperationOnStep.getTransport();
                    copyTransport.setParent(system);
                    system.addTransport(copyTransport);
                    for (Situation sit : copyOperationOnStep.getSituations()) {
                        IntegrationStep copyIntegrationStep = sit.getIntegrationStep();
                        if (copyIntegrationStep != null) {
                            copyIntegrationStep.setSender(system);
                            copyIntegrationStep.setOperation(copyOperationOnStep);
                            this.determineTemplateParent(copyIntegrationStep.returnStepTemplate(), copyOperationOnStep, system);
                        }
                        HashSet parsingRulesForSet = Sets.newHashSet();
                        for (OperationParsingRule parsingRule : copyOperationOnStep.getOperationParsingRules()) {
                            for (ParsingRule sitParsingRule : sit.getParsingRules()) {
                                if (parsingRule.getNaturalId() == null || !sitParsingRule.getID().toString().equals(parsingRule.getNaturalId().toString())) continue;
                                parsingRulesForSet.add(parsingRule);
                            }
                        }
                        sit.setParsingRules(parsingRulesForSet);
                    }
                    copyOperationOnStep.getOperationParsingRules().forEach(operationParsingRule -> operationParsingRule.setParent(copyOperationOnStep));
                    copyOperationOnStep.getOperationTemplates().forEach(operationTemplate -> operationTemplate.setParent(copyOperationOnStep));
                }
            } else {
                integrationStep.setOperation(operation);
            }
        }
    }

    private void postActionsForUpdateTriggerOnSituation(Storable newStorable, String useCase) {
        if (USECASE1.equals(useCase)) {
            for (Operation operation : ((System)newStorable).getOperations()) {
                TransportConfiguration transportConfiguration = operation.getTransport();
                if (transportConfiguration == null) {
                    log.error("TransportConfiguration is null on operation: " + operation.getName() + ", system: " + newStorable.getName());
                    continue;
                }
                if (!transportConfiguration.getMep().isOutbound()) continue;
                for (Situation situation : operation.getSituations()) {
                    for (SituationEventTrigger situationEventTrigger : situation.getSituationEventTriggers()) {
                        Situation situationOnTrigger;
                        if (situationEventTrigger.getSituation() == null || (situationOnTrigger = (Situation)OriginalCopyMap.getInstance().get(this.sessionId, situationEventTrigger.getSituation().getID())) == null) continue;
                        situationEventTrigger.setSituation(situationOnTrigger);
                    }
                }
            }
        }
    }

    private void determineTemplateParent(Template template, Storable operation, Storable system) {
        if (template == null) {
            return;
        }
        this.fixTemplateParent(template, operation, system);
    }

    private void determineTemplateParent(Template template, Storable operation, Storable system, boolean copyFlag) {
        if (template == null) {
            return;
        }
        if (copyFlag) {
            this.fixTemplateParent(template, operation, system);
        } else if (template.getParent() instanceof Operation) {
            template.setParent((Operation)operation);
        }
    }

    private void fixTemplateParent(Template template, Storable operation, Storable system) {
        if (template.getParent() instanceof Operation) {
            template.setParent((Operation)operation);
        } else if (template.getParent() instanceof System) {
            template.setParent((System)system);
        }
    }

    private TransportConfiguration getTransport(Operation operation, System system) {
        TransportConfiguration transportConfiguration = operation.getTransport();
        if (transportConfiguration == null) {
            log.error("TransportConfiguration is null on operation: {}, system: {}", (Object)operation.getName(), (Object)system.getName());
        }
        return transportConfiguration;
    }
}

