/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.engine;

import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.time.DateUtils;
import org.qubership.automation.itf.core.model.counter.Counter;
import org.qubership.automation.itf.core.model.counter.CounterImpl;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.exception.CounterLimitIsExhaustedException;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(CounterEngine.class);
    private static CounterEngine INSTANCE = new CounterEngine();
    private final Map<Set<Object>, Counter> counterMap = Maps.newHashMap();

    private CounterEngine() {
        Collection<Counter> counters = CoreObjectManager.getInstance().getManager(Counter.class).getAll();
        for (Counter counter : counters) {
            if (DateUtils.isSameDay((Date)Calendar.getInstance().getTime(), (Date)counter.getDate())) {
                this.counterMap.put(counter.getOwners(), counter);
                continue;
            }
            counter.remove();
        }
    }

    public static CounterEngine getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextIndex(Set<Object> owners, String counterFormat) throws CounterLimitIsExhaustedException {
        if (counterFormat == null) {
            LOGGER.warn("Counter format is null");
            return null;
        }
        Map<Set<Object>, Counter> map = this.counterMap;
        synchronized (map) {
            for (Map.Entry<Set<Object>, Counter> entry : this.counterMap.entrySet()) {
                if (!entry.getKey().equals(owners)) continue;
                return this.getNextIndexAndStore(entry.getValue());
            }
            return this.newCounter(owners, counterFormat, CounterImpl.class);
        }
    }

    private String prepareIndex(Integer index, String format) {
        if (format.length() == 2) {
            if (index.toString().length() == 1) {
                return "0" + index.toString();
            }
        } else if (format.length() == 3) {
            switch (index.toString().length()) {
                case 1: {
                    return "00" + index.toString();
                }
                case 2: {
                    return "0" + index.toString();
                }
            }
            LOGGER.error("Index length is not 1 or 2.");
        }
        return index.toString();
    }

    private String newCounter(Set<Object> owners, String format, Class clazz) throws CounterLimitIsExhaustedException {
        try {
            return TxExecutor.execute(() -> {
                Counter counter = CoreObjectManager.getInstance().getManager(Counter.class).create();
                counter.setOwners(owners);
                counter.setDate(Calendar.getInstance().getTime());
                counter.setFormat(format);
                counter.setIndex(1);
                counter.store();
                this.counterMap.put(owners, counter);
                return this.prepareIndex(1, format);
            }, TxExecutor.nestedWritableTransaction());
        }
        catch (Exception e) {
            throw new CounterLimitIsExhaustedException("Unable to create new counter", e);
        }
    }

    private String getNextIndexAndStore(Counter counter) throws CounterLimitIsExhaustedException {
        try {
            return TxExecutor.execute(() -> {
                String index = this.prepareIndex(counter.getNextIndex(), counter.getFormat());
                counter.store();
                return index;
            }, TxExecutor.nestedWritableTransaction());
        }
        catch (Exception e) {
            throw new CounterLimitIsExhaustedException("Unable to store counter", e);
        }
    }
}

