/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.generator.id;

import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Map;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.util.generator.id.IdGeneratorInterface;
import org.qubership.automation.itf.core.util.generator.prefix.PrefixGenerator;

public class CounterIdGenerator
implements IdGeneratorInterface {
    private static volatile Map<Class<? extends Storable>, BigInteger> idMapStorage = Maps.newHashMap();

    @Override
    public void setStartFrom(Object id, Class<? extends Storable> clazz) {
        BigInteger bigInteger = new BigInteger(PrefixGenerator.removePrefix(id).toString());
        BigInteger counter = idMapStorage.get(clazz);
        if (counter == null) {
            idMapStorage.put(clazz, BigInteger.ZERO);
            return;
        }
        if (bigInteger.compareTo(counter) == 1) {
            idMapStorage.put(clazz, bigInteger);
        }
    }

    @Override
    public Object getId(Class<? extends Storable> clazz) {
        BigInteger bigInteger = idMapStorage.get(clazz);
        if (bigInteger == null) {
            bigInteger = BigInteger.ZERO;
        }
        BigInteger integer = bigInteger.add(BigInteger.ONE);
        idMapStorage.put(clazz, integer);
        return PrefixGenerator.getPrefix(clazz) + integer.toString();
    }
}

