/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.helper;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.reflect.TypeToken;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.util.ReflectionUtils;

public final class Reflection {
    private static final Reflections REFLECTIONS = new Reflections("org.qubership.automation.itf", new Scanner[0]);
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("\n|;");

    public static Reflections getReflections() {
        return REFLECTIONS;
    }

    public static Object get(Field field, Object owner) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(owner);
            return object;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static List<Field> getFieldsAnnotatedBy(Class clazz, Class<? extends Annotation> annotationClass) {
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList annotatedFields = Lists.newArrayListWithExpectedSize((int)(declaredFields.length / 2 + 5));
        for (Field field : declaredFields) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static void setFieldValue(Class<?> clazz, String name, Object owner, Object value) {
        Reflection.setFieldValue(ReflectionUtils.findField(clazz, (String)name), owner, value);
    }

    public static void setFieldValue(Field field, Object owner, Object value) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(owner, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static String convertToString(Object object) {
        if (object != null) {
            PropertyEditor editor = PropertyEditorManager.findEditor(object.getClass());
            editor.setValue(object);
            editor.getAsText();
            return editor.getAsText();
        }
        return "";
    }

    public static String fromMap(Object object) {
        if (object != null) {
            return Joiner.on((char)'\n').withKeyValueSeparator("=").join((Map)object);
        }
        return "";
    }

    public static String fromArray(Object array) {
        return Joiner.on((char)'\n').skipNulls().join((Object[])array);
    }

    public static String fromCollection(Object collection) {
        return Joiner.on((char)'\n').skipNulls().join((Iterable)collection);
    }

    public static <T> T convertFromString(Class<T> targetType, String text) {
        if (!Strings.isNullOrEmpty((String)text)) {
            PropertyEditor editor = PropertyEditorManager.findEditor(targetType);
            editor.setAsText(text);
            return (T)editor.getValue();
        }
        return null;
    }

    public static <T> T[] toArray(Class<T> targetType, String values) {
        if (!Strings.isNullOrEmpty((String)values)) {
            List list = Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)values);
            Object[] array = ObjectArrays.newArray(targetType, (int)list.size());
            int i = 0;
            for (String value : list) {
                array[i++] = Reflection.convertFromString(targetType, value);
            }
            return array;
        }
        return null;
    }

    public static Map<String, Object> toStringMap(String text) {
        if (!Strings.isNullOrEmpty((String)text)) {
            HashMap map = Maps.newHashMap();
            Splitter splitter = Splitter.on((char)'=').trimResults().limit(2);
            for (String string : Splitter.on((char)'\n').omitEmptyStrings().trimResults().split((CharSequence)text)) {
                String[] array = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)string), String.class);
                if (array.length != 2) continue;
                if (map.containsKey(array[0])) {
                    ArrayList<String> list;
                    Object oldValue = map.get(array[0]);
                    if (oldValue instanceof List) {
                        list = (ArrayList<String>)oldValue;
                    } else {
                        list = new ArrayList<String>();
                        list.add(oldValue.toString());
                    }
                    list.add(array[1]);
                    map.replace(array[0], list);
                    continue;
                }
                map.put(array[0], array[1]);
            }
            return map;
        }
        return null;
    }

    public static Collection toCollection(final Class<?> targetType, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            return Lists.newArrayList(Collections2.transform((Collection)Splitter.on((Pattern)SEPARATOR_PATTERN).omitEmptyStrings().trimResults().splitToList((CharSequence)value), (Function)new Function<String, Object>(){

                public Object apply(String s) {
                    return Reflection.convertFromString(targetType, s);
                }
            }).iterator());
        }
        return null;
    }

    public static Object detectAndConvertFromString(Class targetClass, String value) {
        value = Strings.nullToEmpty((String)value);
        Object converted = Collection.class.isAssignableFrom(targetClass) ? Reflection.toCollection(String.class, value) : (Map.class.isAssignableFrom(targetClass) ? Reflection.toStringMap(value) : (TypeToken.of((Class)targetClass).isArray() ? Reflection.toArray(TypeToken.of((Class)targetClass).getComponentType().getRawType(), value) : ("java.lang.String".equals(targetClass.getName()) ? value : ("java.lang.Integer".equals(targetClass.getName()) ? (Constable)Integer.valueOf(value) : (Constable)("java.lang.Boolean".equals(targetClass.getName()) ? Boolean.valueOf(Boolean.parseBoolean(value)) : Reflection.convertFromString(targetClass, value))))));
        return converted;
    }

    public static Object detectAndConvertFromString(Field field, String value) {
        return Reflection.detectAndConvertFromString(field.getType(), value);
    }

    public static String detectAndConvertToString(Object object) {
        if (object == null) {
            return "";
        }
        if (Collection.class.isAssignableFrom(object.getClass())) {
            return Reflection.fromCollection(object);
        }
        if (Map.class.isAssignableFrom(object.getClass())) {
            return Reflection.fromMap(object);
        }
        if (TypeToken.of(object.getClass()).isArray()) {
            return Reflection.fromArray(object);
        }
        return Reflection.convertToString(object);
    }

    public static String detectAndConvertToString(Field field, Object object) {
        return Reflection.detectAndConvertToString(Reflection.get(field, object));
    }
}

