/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.helper;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import java.util.UUID;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.representations.IDToken;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.springframework.stereotype.Component;

@Component(value="securityHelper")
public class SecurityHelper {
    private static final Random RANDOM = new SecureRandom();
    private static final int ITERATIONS = 1000;
    private static final int KEY_LENGTH = 512;
    private static final String ALGORITHM = "PBKDF2WithHmacSHA1";

    @Deprecated
    public static byte[] getSalt() {
        byte[] salt = new byte[16];
        RANDOM.nextBytes(salt);
        return salt;
    }

    @Deprecated
    public static boolean arePasswordsEquals(String testedPassword, byte[] storedPassword, byte[] salt) {
        byte[] hashedTestedPassword = SecurityHelper.encodePassword(testedPassword.toCharArray(), salt);
        if (hashedTestedPassword.length != storedPassword.length) {
            return false;
        }
        for (int i = 0; i < hashedTestedPassword.length; ++i) {
            if (hashedTestedPassword[i] == storedPassword[i]) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static byte[] encodePassword(char[] password, byte[] salt) {
        PBEKeySpec spec = new PBEKeySpec(password, salt, 1000, 512);
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(ALGORITHM);
            byte[] byArray = skf.generateSecret(spec).getEncoded();
            return byArray;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AssertionError("Error while hashing a password: " + e.getMessage(), e);
        }
        finally {
            spec.clearPassword();
        }
    }

    public static UUID getCurrentProjectUuid(BigInteger projectId) {
        return CoreObjectManager.getInstance().getManager(StubProject.class).getById(projectId).getUuid();
    }

    @Deprecated
    public static IDToken getTokenForLogger(KeycloakPrincipal principal) {
        IDToken idToken = principal.getKeycloakSecurityContext().getIdToken();
        if (idToken == null) {
            idToken = principal.getKeycloakSecurityContext().getToken();
        }
        return idToken;
    }
}

