/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.holder;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.qubership.automation.itf.core.model.jpa.system.stub.Listener;

public class EventTriggerHolder {
    private Map<Object, Listener> listenerMap = Maps.newConcurrentMap();
    private Map<Object, List<Listener>> situationOnStartListenersMap = Maps.newConcurrentMap();
    private static final EventTriggerHolder INSTANCE = new EventTriggerHolder();

    public static EventTriggerHolder getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Listener listener, boolean isStartListener) {
        this.listenerMap.put(listener.getId(), listener);
        if (isStartListener) {
            Object object = listener.getSituationId();
            synchronized (object) {
                List list = this.situationOnStartListenersMap.getOrDefault(listener.getSituationId(), new ArrayList());
                list.add(listener);
                this.situationOnStartListenersMap.put(listener.getSituationId(), list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Listener listener, boolean isStartListener) {
        if (listener != null) {
            this.listenerMap.remove(listener.getId());
            if (isStartListener) {
                Object object = listener.getSituationId();
                synchronized (object) {
                    List<Listener> list = this.situationOnStartListenersMap.get(listener.getSituationId());
                    if (list != null) {
                        list.remove(listener);
                    }
                }
            }
        }
    }

    public Map<Object, Listener> getAll() {
        return this.listenerMap;
    }

    public Listener get(Object id) {
        return this.listenerMap.get(id);
    }

    public List<Listener> getOnStartSituationListeners(Object id) {
        return this.situationOnStartListenersMap.get(id);
    }
}

