/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.manager;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.constants.TransportState;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerStateManager {
    private static final TriggerStateManager INSTANCE = new TriggerStateManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(Environment.class);
    private final LoadingCache<String, TransportState> transportStateCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, TransportState>(){

        public TransportState load(@Nonnull String transportType) throws Exception {
            return TransportRegistryManager.getInstance().getState(transportType);
        }
    });

    private TriggerStateManager() {
    }

    public static TriggerStateManager getInstance() {
        return INSTANCE;
    }

    public TriggerState getInboundTriggersState(Environment environment) {
        HashSet triggerStates = Sets.newHashSetWithExpectedSize((int)5);
        for (Map.Entry<System, Server> entry : environment.getInbound().entrySet()) {
            if (entry.getValue() != null) {
                for (InboundTransportConfiguration configuration : entry.getValue().getInbounds(entry.getKey())) {
                    triggerStates.add(this.getInboundTransportConfigurationStatus(configuration));
                }
                continue;
            }
            LOGGER.warn("Server is empty for system {} at environment {}", (Object)entry.getKey(), (Object)this);
        }
        TriggerState result = this.stateCalculationForStub(triggerStates);
        return this.updateStatusForEnvironment(result, environment);
    }

    private TriggerState updateStatusForEnvironment(TriggerState result, Environment environment) {
        if (result == null) {
            result = TriggerState.EMPTY;
            environment.setEnvironmentState(result);
            environment.store();
        } else if (!result.equals((Object)environment.getEnvironmentState())) {
            environment.setEnvironmentState(result);
            environment.store();
        }
        return result;
    }

    private TriggerState getInboundTransportConfigurationStatus(InboundTransportConfiguration configuration) {
        TriggerState result = TriggerState.INACTIVE;
        if (TransportState.READY.equals((Object)this.getFromCache(configuration))) {
            result = this.getStabInboundTransportConfigurationStatus(configuration);
        }
        return result;
    }

    private TriggerState getTriggerStatus(TriggerConfiguration triggerConfiguration) {
        return TriggerState.INACTIVE;
    }

    private TriggerState getStabInboundTransportConfigurationStatus(InboundTransportConfiguration configuration) {
        HashSet triggerStates = Sets.newHashSetWithExpectedSize((int)4);
        for (TriggerConfiguration triggerConfiguration : configuration.getTriggerConfigurations()) {
            triggerStates.add(this.getTriggerStatus(triggerConfiguration));
        }
        return this.stateCalculationForStub(triggerStates);
    }

    private TriggerState stateCalculationForStub(Set<TriggerState> triggerStates) {
        if (triggerStates.isEmpty()) {
            return TriggerState.EMPTY;
        }
        if (triggerStates.size() == 1) {
            return triggerStates.iterator().next();
        }
        Map<TriggerState, State> states = this.getMapStates();
        for (TriggerState triggerState : triggerStates) {
            this.prepareStates(states, triggerState);
        }
        return this.validateStates(states);
    }

    private TriggerState validateStates(Map<TriggerState, State> states) {
        for (Map.Entry<TriggerState, State> state : states.entrySet()) {
            if (!state.getValue().areAllState.booleanValue()) continue;
            return state.getKey();
        }
        if (states.get((Object)TriggerState.ACTIVE).haveState.booleanValue() && (states.get((Object)TriggerState.ERROR).haveState.booleanValue() || states.get((Object)TriggerState.ACTIVE_ERROR).haveState.booleanValue())) {
            return TriggerState.ACTIVE_ERROR;
        }
        if (states.get((Object)TriggerState.ACTIVE).haveState.booleanValue() && (states.get((Object)TriggerState.INACTIVE).haveState.booleanValue() || states.get((Object)TriggerState.ACTIVE_PART).haveState.booleanValue())) {
            return TriggerState.ACTIVE_PART;
        }
        if (states.get((Object)TriggerState.ACTIVE_ERROR).haveState.booleanValue()) {
            return TriggerState.ACTIVE_ERROR;
        }
        if (states.get((Object)TriggerState.ACTIVE_PART).haveState.booleanValue()) {
            return TriggerState.ACTIVE_PART;
        }
        if (!(!states.get((Object)TriggerState.EMPTY).haveState.booleanValue() || states.get((Object)TriggerState.ERROR).haveState.booleanValue() || states.get((Object)TriggerState.INACTIVE).haveState.booleanValue() || states.get((Object)TriggerState.ACTIVE).haveState.booleanValue() || states.get((Object)TriggerState.ACTIVE_ERROR).haveState.booleanValue() || states.get((Object)TriggerState.ACTIVE_PART).haveState.booleanValue())) {
            return TriggerState.EMPTY;
        }
        if (states.get((Object)TriggerState.ACTIVE).haveState.booleanValue() && states.get((Object)TriggerState.EMPTY).haveState.booleanValue()) {
            return TriggerState.ACTIVE;
        }
        if (states.get((Object)TriggerState.EMPTY).haveState.booleanValue() && states.get((Object)TriggerState.ERROR).haveState.booleanValue()) {
            return TriggerState.ERROR;
        }
        return TriggerState.INACTIVE;
    }

    private void prepareStates(Map<TriggerState, State> states, TriggerState triggerState) {
        if (Objects.isNull((Object)triggerState)) {
            triggerState = TriggerState.EMPTY;
        }
        for (Map.Entry<TriggerState, State> state : states.entrySet()) {
            this.prepareState(state, triggerState);
        }
    }

    private void prepareState(Map.Entry<TriggerState, State> state, TriggerState triggerState) {
        if (!triggerState.equals((Object)state.getKey())) {
            state.getValue().areAllState = false;
        } else {
            state.getValue().haveState = true;
        }
    }

    private Map<TriggerState, State> getMapStates() {
        HashMap states = Maps.newHashMapWithExpectedSize((int)3);
        states.put(TriggerState.ACTIVE, new State(true, false));
        states.put(TriggerState.ERROR, new State(true, false));
        states.put(TriggerState.INACTIVE, new State(true, false));
        states.put(TriggerState.ACTIVE_PART, new State(true, false));
        states.put(TriggerState.ACTIVE_ERROR, new State(true, false));
        states.put(TriggerState.EMPTY, new State(true, false));
        return states;
    }

    private TransportState getFromCache(InboundTransportConfiguration configuration) {
        try {
            return (TransportState)((Object)this.transportStateCache.get((Object)configuration.getReferencedConfiguration().getTypeName()));
        }
        catch (ExecutionException e) {
            LOGGER.warn("Unable to get transport state from cache", (Throwable)e);
            return TransportRegistryManager.getInstance().getState(configuration.getReferencedConfiguration().getTypeName());
        }
    }

    private static class State {
        private Boolean areAllState = true;
        private Boolean haveState = false;

        private State(Boolean areAllState, Boolean haveState) {
            this.areAllState = areAllState;
            this.haveState = haveState;
        }
    }
}

