/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.registry;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.descriptor.Extractor;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.engine.EngineIntegration;
import org.qubership.automation.itf.core.util.helper.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineIntegrationRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineIntegrationRegistry.class);
    private static EngineIntegrationRegistry INSTANCE = new EngineIntegrationRegistry();
    private Map<String, EngineIntegration> engines = Maps.newHashMapWithExpectedSize((int)50);
    private Map<String, List<PropertyDescriptor>> properties = Maps.newHashMapWithExpectedSize((int)50);

    private EngineIntegrationRegistry() {
        this.init();
    }

    public static EngineIntegrationRegistry getInstance() {
        return INSTANCE;
    }

    public void init() {
        Set classes = Reflection.getReflections().getSubTypesOf(EngineIntegration.class);
        for (Class clazz : classes) {
            if (clazz.isInterface()) continue;
            try {
                EngineIntegration integration = (EngineIntegration)clazz.newInstance();
                UserName userName = clazz.getAnnotation(UserName.class);
                String name = userName != null ? userName.value() : clazz.getSimpleName();
                this.engines.put(name, integration);
                List<PropertyDescriptor> descriptors = Extractor.extractProperties(integration);
                this.properties.put(name, descriptors);
                LOGGER.info("Class {} is loaded successfully", (Object)clazz.getSimpleName());
            }
            catch (IllegalAccessException | InstantiationException ex) {
                LOGGER.error("Error in initializer of {}", (Object)clazz.getName(), (Object)ex);
            }
        }
    }

    public EngineIntegration find(String engineName) {
        return this.engines.get(engineName);
    }

    public List<PropertyDescriptor> getProperties(String engineName) {
        return this.properties.get(engineName);
    }

    public Collection<String> getAvailableIntegrations() {
        return Sets.newHashSet(this.engines.keySet());
    }

    public Map<String, EngineIntegration> getAvailableEngines() {
        return this.engines;
    }
}

