/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.datasets.controllers;

import java.math.BigDecimal;
import org.qubership.atp.datasets.dto.DataSetTreeDto;
import org.qubership.atp.datasets.dto.LabelDto;
import java.util.List;
import java.util.Map;
import org.qubership.atp.datasets.dto.ObjectShortResponseDto;
import org.qubership.atp.datasets.dto.PageAbstractEntityResponseDto;
import org.qubership.atp.datasets.dto.PairOfUUidAndIntDto;
import org.qubership.atp.datasets.dto.ParameterDto;
import org.qubership.atp.datasets.dto.TableResponseDto;
import java.util.UUID;
import org.qubership.atp.datasets.dto.UiManAttributeDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-25T09:49:09.834Z[Etc/UTC]")
@Validated
@Tag(name = "DataSetController", description = "Data Set Controller")
public interface DataSetControllerApi {

    /**
     * PUT /ds/{dataSetId}/label : addLabel
     *
     * @param dataSetId dataSetId (required)
     * @param name name (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "addLabel",
        summary = "addLabel",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/ds/{dataSetId}/label",
        produces = { "application/json" }
    )
    ResponseEntity<LabelDto> addLabel(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * PUT /ds/{dataSetId}/copy : Copy DS with name provided.
     *
     * @param dataSetId dataSetId (required)
     * @param name name (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copy",
        summary = "Copy DS with name provided.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/ds/{dataSetId}/copy",
        produces = { "application/json" }
    )
    ResponseEntity<UUID> copy(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name
    );


    /**
     * PUT /ds/{dataSetListId}/ds : Creates new DS with name provided.
     *
     * @param dataSetListId dataSetListId (required)
     * @param name name (required)
     * @param modifiedWhen modifiedWhen (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "create",
        summary = "Creates new DS with name provided.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/ds/{dataSetListId}/ds",
        produces = { "application/json" }
    )
    ResponseEntity<UUID> create(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * DELETE /ds/{dataSetId} : Deletes selected DS.
     *
     * @param dataSetId dataSetId (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "delete",
        summary = "Deletes selected DS.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/ds/{dataSetId}"
    )
    ResponseEntity<Void> delete(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * DELETE /ds/{dataSetId}/label/{labelId} : deleteLabel
     *
     * @param dataSetId dataSetId (required)
     * @param labelId labelId (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteLabel",
        summary = "deleteLabel",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Boolean.class))
            }),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/ds/{dataSetId}/label/{labelId}",
        produces = { "application/json" }
    )
    ResponseEntity<Boolean> deleteLabel(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "labelId", description = "labelId", required = true) @PathVariable("labelId") UUID labelId,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * GET /ds/{dataSetId}/affectedDatasets : Returns all affected dataSets by specified reference with pagination support.
     *
     * @param dataSetId dataSetId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAffectedDataSets",
        summary = "Returns all affected dataSets by specified reference with pagination support.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TableResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds/{dataSetId}/affectedDatasets",
        produces = { "application/json" }
    )
    ResponseEntity<List<TableResponseDto>> getAffectedDataSets(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId
    );


    /**
     * GET /ds/dsReferenceId/affected/by : Returns all affected dataSets by changes at reference value.
     *
     * @param dsReferenceId dsReferenceId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAffectedDataSetsByChangesDataSetReference",
        summary = "Returns all affected dataSets by changes at reference value.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds/dsReferenceId/affected/by",
        produces = { "application/json" }
    )
    ResponseEntity<List<Object>> getAffectedDataSetsByChangesDataSetReference(
        @NotNull @Parameter(name = "dsReferenceId", description = "dsReferenceId", required = true) @Valid @RequestParam(value = "dsReferenceId", required = true) UUID dsReferenceId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) String full
    );


    /**
     * GET /ds/{dataSetId}/affectedDatasetsCount : Returns all affected dataSets count by specified reference.
     *
     * @param dataSetId dataSetId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAffectedDataSetsCount",
        summary = "Returns all affected dataSets count by specified reference.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = BigDecimal.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds/{dataSetId}/affectedDatasetsCount",
        produces = { "application/json" }
    )
    ResponseEntity<BigDecimal> getAffectedDataSetsCount(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId
    );


    /**
     * POST /ds/{dataSetId}/atp : Returns dataSet by id in ITF format + atp macros
     *
     * @param dataSetId dataSetId (required)
     * @param evaluate evaluate (optional)
     * @param body  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAtpContextFull",
        summary = "Returns dataSet by id in ITF format + atp macros",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetTreeDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/{dataSetId}/atp",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<DataSetTreeDto> getAtpContextFull(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "evaluate", description = "evaluate") @Valid @RequestParam(value = "evaluate", required = false) String evaluate,
        @Parameter(name = "body", description = "") @Valid @RequestBody(required = false) String body
    );


    /**
     * POST /ds/{dataSetId}/atp/bulk : Returns dataSet by id in ITF format + atp macros
     *
     * @param dataSetId dataSetId (required)
     * @param evaluate evaluate (optional)
     * @param countOfEvaluates countOfEvaluates (optional)
     * @param requestBody  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAtpContextFullBulk",
        summary = "Returns dataSet by id in ITF format + atp macros",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/{dataSetId}/atp/bulk",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<Object>> getAtpContextFullBulk(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "evaluate", description = "evaluate") @Valid @RequestParam(value = "evaluate", required = false) String evaluate,
        @Parameter(name = "countOfEvaluates", description = "countOfEvaluates") @Valid @RequestParam(value = "countOfEvaluates", required = false) Integer countOfEvaluates,
        @Parameter(name = "request_body", description = "") @Valid @RequestBody(required = false) Map<String, String> requestBody
    );


    /**
     * POST /ds/{dataSetId}/atp/object : Returns dataSet by id in ITF format + atp macros
     *
     * @param dataSetId dataSetId (required)
     * @param evaluate evaluate (optional)
     * @param body  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAtpContextObject",
        summary = "Returns dataSet by id in ITF format + atp macros",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetTreeDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/{dataSetId}/atp/object",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<DataSetTreeDto> getAtpContextObject(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "evaluate", description = "evaluate") @Valid @RequestParam(value = "evaluate", required = false) String evaluate,
        @Parameter(name = "body", description = "") @Valid @RequestBody(required = false) String body
    );


    /**
     * POST /ds/{dataSetId}/atp/object/bulk : Returns dataSet by id in ITF format + atp macros
     *
     * @param dataSetId dataSetId (required)
     * @param evaluate evaluate (optional)
     * @param countOfEvaluates countOfEvaluates (optional)
     * @param requestBody  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAtpContextObjectBulk",
        summary = "Returns dataSet by id in ITF format + atp macros",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/{dataSetId}/atp/object/bulk",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<Object>> getAtpContextObjectBulk(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "evaluate", description = "evaluate") @Valid @RequestParam(value = "evaluate", required = false) String evaluate,
        @Parameter(name = "countOfEvaluates", description = "countOfEvaluates") @Valid @RequestParam(value = "countOfEvaluates", required = false) Integer countOfEvaluates,
        @Parameter(name = "request_body", description = "") @Valid @RequestBody(required = false) Map<String, String> requestBody
    );


    /**
     * POST /ds/{dataSetId}/atp/objectExtended : Returns dataSet by id in ATP format + atp macros
     *
     * @param dataSetId dataSetId (required)
     * @param evaluate evaluate (optional)
     * @param body  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAtpContextObjectExtended",
        summary = "Returns dataSet by id in ATP format + atp macros",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetTreeDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/{dataSetId}/atp/objectExtended",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<DataSetTreeDto> getAtpContextObjectExtended(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "evaluate", description = "evaluate") @Valid @RequestParam(value = "evaluate", required = false) String evaluate,
        @Parameter(name = "body", description = "") @Valid @RequestBody(required = false) String body
    );


    /**
     * POST /ds/{dataSetId}/atp/optimized : Returns dataSet by id in ITF format + atp macros
     *
     * @param dataSetId dataSetId (required)
     * @param evaluate evaluate (optional)
     * @param body  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAtpContextOptimized",
        summary = "Returns dataSet by id in ITF format + atp macros",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetTreeDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/{dataSetId}/atp/optimized",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<DataSetTreeDto> getAtpContextOptimized(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "evaluate", description = "evaluate") @Valid @RequestParam(value = "evaluate", required = false) String evaluate,
        @Parameter(name = "body", description = "") @Valid @RequestBody(required = false) String body
    );


    /**
     * POST /ds/{dataSetId}/atp/optimized/bulk : Returns dataSet by id in ITF format + atp macros
     *
     * @param dataSetId dataSetId (required)
     * @param evaluate evaluate (optional)
     * @param countOfEvaluates countOfEvaluates (optional)
     * @param requestBody  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAtpContextOptimizedBulk",
        summary = "Returns dataSet by id in ITF format + atp macros",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/{dataSetId}/atp/optimized/bulk",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<Object>> getAtpContextOptimizedBulk(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "evaluate", description = "evaluate") @Valid @RequestParam(value = "evaluate", required = false) String evaluate,
        @Parameter(name = "countOfEvaluates", description = "countOfEvaluates") @Valid @RequestParam(value = "countOfEvaluates", required = false) Integer countOfEvaluates,
        @Parameter(name = "request_body", description = "") @Valid @RequestBody(required = false) Map<String, String> requestBody
    );


    /**
     * GET /ds/{dataSetId} : Returns dataSet by id.
     *
     * @param dataSetId dataSetId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetById",
        summary = "Returns dataSet by id.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds/{dataSetId}",
        produces = { "application/json" }
    )
    ResponseEntity<Object> getDataSetById(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId
    );


    /**
     * GET /ds : Returns all dataSets.
     *
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSets",
        summary = "Returns all dataSets.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds",
        produces = { "application/json" }
    )
    ResponseEntity<List<Object>> getDataSets(
        
    );


    /**
     * GET /ds/find-name-pagination : Returns all dataSets.
     *
     * @param name name (required)
     * @param projectId projectId (required)
     * @param offset  (optional)
     * @param pageNumber  (optional)
     * @param pageSize  (optional)
     * @param paged  (optional)
     * @param sortSorted  (optional)
     * @param sortUnsorted  (optional)
     * @param unpaged  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetsByName",
        summary = "Returns all dataSets.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = PageAbstractEntityResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds/find-name-pagination",
        produces = { "application/json" }
    )
    ResponseEntity<PageAbstractEntityResponseDto> getDataSetsByName(
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name,
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true) @Valid @RequestParam(value = "projectId", required = true) UUID projectId,
        @Parameter(name = "offset", description = "") @Valid @RequestParam(value = "offset", required = false) Long offset,
        @Parameter(name = "pageNumber", description = "") @Valid @RequestParam(value = "pageNumber", required = false) Integer pageNumber,
        @Parameter(name = "pageSize", description = "") @Valid @RequestParam(value = "pageSize", required = false) Integer pageSize,
        @Parameter(name = "paged", description = "") @Valid @RequestParam(value = "paged", required = false) Boolean paged,
        @Parameter(name = "sort.sorted", description = "") @Valid @RequestParam(value = "sort.sorted", required = false) Boolean sortSorted,
        @Parameter(name = "sort.unsorted", description = "") @Valid @RequestParam(value = "sort.unsorted", required = false) Boolean sortUnsorted,
        @Parameter(name = "unpaged", description = "") @Valid @RequestParam(value = "unpaged", required = false) Boolean unpaged
    );


    /**
     * POST /ds/{dataSetId}/legacy/atp : Returns dataSet by id in ITF format + atp macros
     *
     * @param dataSetId dataSetId (required)
     * @param evaluate evaluate (optional)
     * @param body  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetsForAtp",
        summary = "Returns dataSet by id in ITF format + atp macros",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/{dataSetId}/legacy/atp",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<Object> getDataSetsForAtp(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") String dataSetId,
        @Parameter(name = "evaluate", description = "evaluate") @Valid @RequestParam(value = "evaluate", required = false) String evaluate,
        @Parameter(name = "body", description = "") @Valid @RequestBody(required = false) String body
    );


    /**
     * GET /ds/{dataSetListId}/short : Returns list of Datasets (id + name) for selected DSL.
     *
     * @param dataSetListId dataSetListId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetsShort",
        summary = "Returns list of Datasets (id + name) for selected DSL.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ObjectShortResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds/{dataSetListId}/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<ObjectShortResponseDto>> getDataSetsShort(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * GET /ds/affected/by : Returns all affected datasets by changes at attribute.
     *
     * @param dataSetId dataSetId (required)
     * @param attributeId attributeId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDatasetsOrTableResponseAffectedByChangeParameterValue",
        summary = "Returns all affected datasets by changes at attribute.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds/affected/by",
        produces = { "application/json" }
    )
    ResponseEntity<List<Object>> getDatasetsOrTableResponseAffectedByChangeParameterValue(
        @NotNull @Parameter(name = "dataSetId", description = "dataSetId", required = true) @Valid @RequestParam(value = "dataSetId", required = true) UUID dataSetId,
        @NotNull @Parameter(name = "attributeId", description = "attributeId", required = true) @Valid @RequestParam(value = "attributeId", required = true) UUID attributeId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) String full
    );


    /**
     * GET /ds/{dataSetId}/legacy/itf : Returns dataSet by id in ITF format: {attribute &#x3D; parameter, attribute2 : {attribute &#x3D; parameter2}}.
     *
     * @param dataSetId dataSetId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getInItfFormat",
        summary = "Returns dataSet by id in ITF format: {attribute = parameter, attribute2 : {attribute = parameter2}}.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds/{dataSetId}/legacy/itf",
        produces = { "application/json" }
    )
    ResponseEntity<Object> getInItfFormat(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") String dataSetId
    );


    /**
     * GET /ds/{dataSetId}/itf : Returns dataSet by id in ITF format + atp macros
     *
     * @param dataSetId dataSetId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getItfContext",
        summary = "Returns dataSet by id in ITF format + atp macros",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds/{dataSetId}/itf",
        produces = { "application/json" }
    )
    ResponseEntity<String> getItfContext(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId
    );


    /**
     * GET /ds/{dataSetId}/label : getLabels
     *
     * @param dataSetId dataSetId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getLabels",
        summary = "getLabels",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds/{dataSetId}/label",
        produces = { "application/json" }
    )
    ResponseEntity<List<LabelDto>> getLabels(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId
    );


    /**
     * GET /ds/parent/path : returns visibility area and data set list ids
     *
     * @param dsId dsId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getPath",
        summary = "returns visibility area and data set list ids",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = PairOfUUidAndIntDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ds/parent/path",
        produces = { "application/json" }
    )
    ResponseEntity<PairOfUUidAndIntDto> getPath(
        @NotNull @Parameter(name = "dsId", description = "dsId", required = true) @Valid @RequestParam(value = "dsId", required = true) UUID dsId
    );


    /**
     * POST /ds/{dataSetId}/parameters : getUiAttribute
     *
     * @param dataSetId dataSetId (required)
     * @param evaluate evaluate (optional)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getUiAttribute",
        summary = "getUiAttribute",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UiManAttributeDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/{dataSetId}/parameters",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<UiManAttributeDto> getUiAttribute(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "evaluate", description = "evaluate") @Valid @RequestParam(value = "evaluate", required = false) String evaluate,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /ds/lock/update : Lock DS from change.
     *
     * @param dataSetListId dataSetListId (required)
     * @param locked locked ds flag (required)
     * @param modifiedWhen modifiedWhen (optional)
     * @param UUID  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "lock",
        summary = "Lock DS from change.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/lock/update",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> lock(
        @NotNull @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @Valid @RequestParam(value = "dataSetListId", required = true) UUID dataSetListId,
        @NotNull @Parameter(name = "locked", description = "locked ds flag", required = true) @Valid @RequestParam(value = "locked", required = true) Boolean locked,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /ds/{dataSetId} : Renames DS.
     *
     * @param dataSetId dataSetId (required)
     * @param name name (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "rename",
        summary = "Renames DS.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/{dataSetId}"
    )
    ResponseEntity<Void> rename(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * POST /ds/reset/by : Reset all selected datasets, at changed attribute. dataSetIds is ids of datasets in which we want to reset overridden parameters with attributeId provided
     *
     * @param dataSetId dataSetId (required)
     * @param targetAttrId targetAttrId (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "resetOverriddenParameter",
        summary = "Reset all selected datasets, at changed attribute. dataSetIds is ids of datasets in which we want to reset overridden parameters with attributeId provided",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ParameterDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/reset/by",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ParameterDto> resetOverriddenParameter(
        @NotNull @Parameter(name = "dataSetId", description = "dataSetId", required = true) @Valid @RequestParam(value = "dataSetId", required = true) UUID dataSetId,
        @NotNull @Parameter(name = "targetAttrId", description = "targetAttrId", required = true) @Valid @RequestParam(value = "targetAttrId", required = true) UUID targetAttrId,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /ds/reset/affected/by : Reset all selected datasets, at changed attribute
     *
     * @param attributeId attributeId (optional)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @param UUID  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "restAffectedDatasetsByChangesAttribute",
        summary = "Reset all selected datasets, at changed attribute",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/reset/affected/by",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> restAffectedDatasetsByChangesAttribute(
        @Parameter(name = "attributeId", description = "attributeId") @Valid @RequestParam(value = "attributeId", required = false) UUID attributeId,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * POST /ds/restore : restore
     *
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @param body  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "restore",
        summary = "restore",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Boolean.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/restore",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<Boolean> restore(
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen,
        @Parameter(name = "body", description = "") @Valid @RequestBody(required = false) Object body
    );


    /**
     * POST /ds/{dataSetId}/position : Creates new list values for provided attribute by text.
     *
     * @param dataSetId dataSetId (required)
     * @param body  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "setPosition",
        summary = "Creates new list values for provided attribute by text.",
        tags = { "data-set-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ds/{dataSetId}/position",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> setPosition(
        @Parameter(name = "dataSetId", description = "dataSetId", required = true) @PathVariable("dataSetId") UUID dataSetId,
        @Parameter(name = "body", description = "") @Valid @RequestBody(required = false) Integer body
    );

}
