package org.qubership.atp.datasets.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.datasets.dto.AbstractParameterDto;
import org.qubership.atp.datasets.dto.AttributeTypeDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DataSetGroupDto
 */

@JsonTypeName("DataSetGroup")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-25T09:49:09.834Z[Etc/UTC]")
public class DataSetGroupDto {

  @JsonProperty("dataSetId")
  private UUID dataSetId;

  @JsonProperty("dsl")
  private String dsl;

  @JsonProperty("groups")
  @Valid
  private Map<String, DataSetGroupDto> groups = null;

  @JsonProperty("parameters")
  @Valid
  private Map<String, AbstractParameterDto> parameters = null;

  @JsonProperty("type")
  private AttributeTypeDto type;

  @JsonProperty("value")
  private String value;

  public DataSetGroupDto dataSetId(UUID dataSetId) {
    this.dataSetId = dataSetId;
    return this;
  }

  /**
   * Get dataSetId
   * @return dataSetId
  */
  @Valid 
  @Schema(name = "dataSetId", required = false)
  public UUID getDataSetId() {
    return dataSetId;
  }

  public void setDataSetId(UUID dataSetId) {
    this.dataSetId = dataSetId;
  }

  public DataSetGroupDto dsl(String dsl) {
    this.dsl = dsl;
    return this;
  }

  /**
   * Get dsl
   * @return dsl
  */
  
  @Schema(name = "dsl", required = false)
  public String getDsl() {
    return dsl;
  }

  public void setDsl(String dsl) {
    this.dsl = dsl;
  }

  public DataSetGroupDto groups(Map<String, DataSetGroupDto> groups) {
    this.groups = groups;
    return this;
  }

  public DataSetGroupDto putGroupsItem(String key, DataSetGroupDto groupsItem) {
    if (this.groups == null) {
      this.groups = new HashMap<>();
    }
    this.groups.put(key, groupsItem);
    return this;
  }

  /**
   * Get groups
   * @return groups
  */
  @Valid 
  @Schema(name = "groups", required = false)
  public Map<String, DataSetGroupDto> getGroups() {
    return groups;
  }

  public void setGroups(Map<String, DataSetGroupDto> groups) {
    this.groups = groups;
  }

  public DataSetGroupDto parameters(Map<String, AbstractParameterDto> parameters) {
    this.parameters = parameters;
    return this;
  }

  public DataSetGroupDto putParametersItem(String key, AbstractParameterDto parametersItem) {
    if (this.parameters == null) {
      this.parameters = new HashMap<>();
    }
    this.parameters.put(key, parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  @Valid 
  @Schema(name = "parameters", required = false)
  public Map<String, AbstractParameterDto> getParameters() {
    return parameters;
  }

  public void setParameters(Map<String, AbstractParameterDto> parameters) {
    this.parameters = parameters;
  }

  public DataSetGroupDto type(AttributeTypeDto type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", required = false)
  public AttributeTypeDto getType() {
    return type;
  }

  public void setType(AttributeTypeDto type) {
    this.type = type;
  }

  public DataSetGroupDto value(String value) {
    this.value = value;
    return this;
  }

  /**
   * Get value
   * @return value
  */
  
  @Schema(name = "value", required = false)
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetGroupDto dataSetGroup = (DataSetGroupDto) o;
    return Objects.equals(this.dataSetId, dataSetGroup.dataSetId) &&
        Objects.equals(this.dsl, dataSetGroup.dsl) &&
        Objects.equals(this.groups, dataSetGroup.groups) &&
        Objects.equals(this.parameters, dataSetGroup.parameters) &&
        Objects.equals(this.type, dataSetGroup.type) &&
        Objects.equals(this.value, dataSetGroup.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataSetId, dsl, groups, parameters, type, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetGroupDto {\n");
    sb.append("    dataSetId: ").append(toIndentedString(dataSetId)).append("\n");
    sb.append("    dsl: ").append(toIndentedString(dsl)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

