package org.qubership.atp.datasets.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DataSetListDependencyNodeDto
 */

@JsonTypeName("DataSetListDependencyNode")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-25T09:49:10.086Z[Etc/UTC]")
public class DataSetListDependencyNodeDto {

  @JsonProperty("dependencies")
  @Valid
  private List<DataSetListDependencyNodeDto> dependencies = null;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("name")
  private String name;

  public DataSetListDependencyNodeDto dependencies(List<DataSetListDependencyNodeDto> dependencies) {
    this.dependencies = dependencies;
    return this;
  }

  public DataSetListDependencyNodeDto addDependenciesItem(DataSetListDependencyNodeDto dependenciesItem) {
    if (this.dependencies == null) {
      this.dependencies = new ArrayList<>();
    }
    this.dependencies.add(dependenciesItem);
    return this;
  }

  /**
   * Get dependencies
   * @return dependencies
  */
  @Valid 
  @Schema(name = "dependencies", required = false)
  public List<DataSetListDependencyNodeDto> getDependencies() {
    return dependencies;
  }

  public void setDependencies(List<DataSetListDependencyNodeDto> dependencies) {
    this.dependencies = dependencies;
  }

  public DataSetListDependencyNodeDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public DataSetListDependencyNodeDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetListDependencyNodeDto dataSetListDependencyNode = (DataSetListDependencyNodeDto) o;
    return Objects.equals(this.dependencies, dataSetListDependencyNode.dependencies) &&
        Objects.equals(this.id, dataSetListDependencyNode.id) &&
        Objects.equals(this.name, dataSetListDependencyNode.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dependencies, id, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetListDependencyNodeDto {\n");
    sb.append("    dependencies: ").append(toIndentedString(dependencies)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

