/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.actuator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.UpgradeHistoryObjectManager;
import org.qubership.automation.itf.core.model.jpa.versions.UpgradeHistory;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"file:./buildVersion.properties"}, ignoreResourceNotFound=true)
public class BuildInfo
implements InfoContributor {
    @Autowired
    private Environment env;

    public void contribute(Info.Builder builder) {
        String currentBuildVersion = this.env.getProperty("application.version");
        if (currentBuildVersion != null) {
            builder.withDetail("build", Collections.singletonMap("version", currentBuildVersion));
        }
        Collection allBuildsHistory = CoreObjectManager.getInstance().getSpecialManager(UpgradeHistory.class, UpgradeHistoryObjectManager.class).getAll();
        Collections.reverse((List)allBuildsHistory);
        LinkedHashMap buildsHistory = new LinkedHashMap();
        int count = allBuildsHistory.size();
        for (UpgradeHistory upgradeHistory : allBuildsHistory) {
            HashMap<String, String> id = new HashMap<String, String>();
            id.put("update_date", upgradeHistory.getUpgradeDatetime().toString());
            id.put("version", upgradeHistory.getName());
            buildsHistory.put(String.valueOf(count), id);
            --count;
        }
        builder.withDetail("last_builds", buildsHistory);
    }
}

