/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import java.util.TimeZone;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import org.qubership.automation.itf.core.CoreConstants;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class CommonHibernateConfiguration {
    @Value(value="${hibernate.second.level.cache.enabled:false}")
    private boolean secondLevelCacheEnabled;
    @Value(value="${hibernate.query.cache.enabled:false}")
    private boolean queryCacheEnabled;
    @Value(value="${hibernate.show.sql:false}")
    private boolean showSql;
    @Value(value="${hibernate.format.sql:false}")
    private boolean formatSql;
    @Value(value="${hibernate.generate.statistics:false}")
    private boolean generateStatistics;
    @Value(value="${hibernate.cache.use.structured.entries:false}")
    private boolean useStructuredEntries;

    @Bean(name={"dataSource"})
    @ConditionalOnProperty(value={"atp.multi-tenancy.enabled"}, havingValue="false")
    public DataSource getDataSource(@Value(value="${spring.datasource.url}") String url, @Value(value="${spring.datasource.username}") String username, @Value(value="${spring.datasource.password}") String password, @Value(value="${spring.datasource.driver-class-name}") String driverClass, @Value(value="${spring.datasource.hikari.maximum-pool-size}") int maxPoolSize, @Value(value="${spring.datasource.hikari.minimum-idle}") int minIdle, @Value(value="${spring.datasource.hikari.idle-timeout}") int idleTimeOut, @Value(value="${spring.datasource.hikari.max-lifetime}") int maxLifeTime) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setMaximumPoolSize(maxPoolSize);
        hikariConfig.setMinimumIdle(minIdle);
        hikariConfig.setIdleTimeout((long)idleTimeOut);
        hikariConfig.setMaxLifetime((long)maxLifeTime);
        hikariConfig.setDriverClassName(driverClass);
        hikariConfig.setJdbcUrl(url);
        hikariConfig.setUsername(username);
        hikariConfig.setPassword(password);
        return new HikariDataSource(hikariConfig);
    }

    @Bean
    public Properties jpaProperties() {
        Properties properties = new Properties();
        properties.setProperty("hibernate.dialect", "org.hibernate.dialect.PostgreSQL9Dialect");
        properties.setProperty("hibernate.order_inserts", "true");
        properties.setProperty("hibernate.order_updates", "true");
        properties.setProperty("hibernate.max_fetch_depth", "0");
        properties.setProperty("hibernate.jdbc.fetch_size", "50");
        properties.setProperty("hibernate.jdbc.batch_size", "10");
        properties.setProperty("hibernate.show_sql", "false");
        properties.setProperty("hibernate.globally_quoted_identifiers", "false");
        properties.setProperty("hibernate.connection.CharSet", "utf8");
        properties.setProperty("hibernate.connection.characterEncoding", "utf8");
        properties.setProperty("hibernate.connection.useUnicode", "true");
        properties.setProperty("hibernate.cache.use_second_level_cache", String.valueOf(this.secondLevelCacheEnabled));
        if (this.secondLevelCacheEnabled) {
            properties.setProperty("hibernate.cache.region.factory_class", "com.hazelcast.hibernate.HazelcastCacheRegionFactory");
            properties.setProperty("hibernate.cache.use_query_cache", String.valueOf(this.queryCacheEnabled));
            properties.setProperty("hibernate.cache.hazelcast.instance_name", CoreConstants.HIBERNATE_CACHE_HAZELCAST_INSTANCE_NAME.stringValue());
        }
        properties.setProperty("hibernate.show_sql", String.valueOf(this.showSql));
        properties.setProperty("hibernate.format_sql", String.valueOf(this.formatSql));
        properties.setProperty("hibernate.generate_statistics", String.valueOf(this.generateStatistics));
        properties.setProperty("hibernate.cache.use_structured_entries", String.valueOf(this.useStructuredEntries));
        return properties;
    }

    @Bean(name={"lockProvider"})
    public LockProvider getLockProvider(DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setDataSource(dataSource);
        JdbcTemplateLockProvider.Configuration configuration = JdbcTemplateLockProvider.Configuration.builder().withJdbcTemplate(jdbcTemplate).withTimeZone(TimeZone.getTimeZone("UTC")).build();
        return new JdbcTemplateLockProvider(configuration);
    }
}

