/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.config;

import com.hazelcast.core.HazelcastInstance;
import java.util.Objects;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.qubership.automation.itf.core.config.CommonHibernateConfiguration;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@Import(value={CommonHibernateConfiguration.class})
public class ExecutorHibernateConfiguration {
    private HazelcastInstance hazelcastInstance;

    @Autowired(required=false)
    public void setHazelcastInstance(@Qualifier(value="hazelcastCacheInstance") HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Bean
    public TxExecutor transactionExecutor(JpaTransactionManager transactionManager) {
        return new TxExecutor((PlatformTransactionManager)transactionManager);
    }

    @Bean(name={"entityManagerFactory"})
    public FactoryBean<EntityManagerFactory> getLocalContainerEntityManagerFactoryBean(DataSource dataSource, Properties jpaProperties) {
        LocalContainerEntityManagerFactoryBean emf = new LocalContainerEntityManagerFactoryBean();
        emf.setPackagesToScan(new String[]{"org.qubership.automation.itf.core.model.jpa"});
        emf.setDataSource(dataSource);
        emf.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        emf.setMappingResources(new String[]{"mapping/Environment.hbm.xml", "mapping/EventTrigger.hbm.xml", "mapping/Folder.hbm.xml", "mapping/Configuration.hbm.xml", "mapping/ParsingRule.hbm.xml", "mapping/Server.hbm.xml", "mapping/Step.hbm.xml", "mapping/StepContainer-CallChain-Situation.hbm.xml", "mapping/System.hbm.xml", "mapping/Operation.hbm.xml", "mapping/StubProject.hbm.xml", "mapping/Template.hbm.xml", "mapping/Interceptor.hbm.xml", "mapping/Counter.hbm.xml", "mapping/UpgradeHistory.hbm.xml", "mapping/EntitiesMigration.hbm.xml"});
        emf.setJpaProperties(Objects.requireNonNull(jpaProperties));
        return emf;
    }

    @Bean(name={"transactionManager"})
    public JpaTransactionManager getJpaTransactionManager(FactoryBean<EntityManagerFactory> entityManagerFactory) throws Exception {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory((EntityManagerFactory)entityManagerFactory.getObject());
        return transactionManager;
    }
}

