/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.base;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Striped;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Triple;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.RootRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.dataset.DataSetListsSource;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.message.parser.OperationParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.SystemParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.step.AbstractCallChainStep;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.constants.Match;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.copier.StorableCopier;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.exception.CopyException;
import org.qubership.automation.itf.core.util.helper.PropertyHelper;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.FluentQuery;

public abstract class AbstractObjectManager<T extends Storable, V extends T>
implements ObjectManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractObjectManager.class);
    private static final Set<Object> SO_CREATION_PREVENTER = Sets.newCopyOnWriteArraySet();
    private static final Set<Object> SO_UPDATE_PREVENTER = Sets.newCopyOnWriteArraySet();
    private static final Set<Object> SO_REMOVAL_PREVENTER = Sets.newCopyOnWriteArraySet();
    private static final int STRIPES = 256;
    private static final Striped<Lock> LOCK_STRIPED = Striped.lazyWeakLock((int)256);
    protected final StorableRepository<V> repository;
    protected final Class<T> myType;
    @PersistenceContext
    protected EntityManager entityManager;

    protected AbstractObjectManager(StorableRepository<V> repository) {
        this.myType = null;
        this.repository = repository;
    }

    protected AbstractObjectManager(Class<T> type, StorableRepository<V> repository) {
        this.myType = type;
        this.repository = repository;
    }

    protected AbstractObjectManager(Class<T> type, RootRepository<V> repository) {
        this.myType = type;
        this.repository = new RootRepositoryWrapper<V>(repository);
    }

    protected static void addToUsages(Collection<UsageInfo> collection, String propertyName, Iterable<? extends Storable> referers) {
        for (Storable storable : referers) {
            UsageInfo usage = new UsageInfo();
            usage.setProperty(propertyName);
            usage.setReferer(storable);
            collection.add(usage);
        }
    }

    @Override
    public Collection<? extends T> getAll() {
        return this.repository.findAll();
    }

    @Override
    public T getById(@Nonnull Object id) {
        BigInteger identifier = IdConverter.toBigInt(id);
        try {
            return (T)((Storable)this.repository.findById(identifier).orElse(null));
        }
        catch (Exception e) {
            LOGGER.warn("Object with ID {} not found", (Object)identifier);
            return null;
        }
    }

    @Override
    public Collection<? extends T> getByNatureId(@Nonnull Object id, @Nonnull Object projectId) {
        return this.repository.findByNaturalId(id.toString());
    }

    @Override
    public Collection<? extends T> getAllByParentId(@Nonnull Object id) {
        return this.repository.findByParentID(IdConverter.toBigInt(id));
    }

    @Override
    public Collection<? extends T> getByName(String name) {
        return this.repository.findByName(name);
    }

    @Override
    public Collection<? extends T> getByPieceOfName(String pieceOfName) {
        return this.repository.findByNameContainingIgnoreCase(pieceOfName);
    }

    @Override
    public Collection<? extends T> getAllByParentName(String name) {
        return this.repository.findByParentName(name);
    }

    @Override
    public Collection<T> getByProperties(BigInteger projectId, Triple<String, Match, ?> ... properties) {
        Collection toReturn;
        Collection<T> all = this.getAll();
        try {
            toReturn = (Collection)all.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            toReturn = Sets.newHashSetWithExpectedSize((int)all.size());
        }
        for (Storable t : all) {
            if (!PropertyHelper.meetsAllProperties(t, properties)) continue;
            toReturn.add(t);
        }
        return toReturn;
    }

    @Override
    public Collection<? extends T> getByParentAndName(Storable parent, String name) {
        return this.repository.findByParentIDAndName(parent.getID(), name);
    }

    @Override
    public Collection<UsageInfo> remove(Storable object, boolean force) {
        if (force) {
            this.repository.delete(object);
            this.afterDelete(object);
            return null;
        }
        Collection<UsageInfo> usages = this.findUsages(object);
        if (usages == null || usages.isEmpty()) {
            this.repository.delete(object);
            this.afterDelete(object);
            return null;
        }
        return usages;
    }

    public void afterDelete(Storable object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreate(T object) {
        if (!SO_CREATION_PREVENTER.contains(object.getID())) {
            Lock lock = (Lock)LOCK_STRIPED.get(object.getID());
            synchronized (lock) {
                if (!SO_CREATION_PREVENTER.contains(object.getID())) {
                    try {
                        TxExecutor.execute(() -> {
                            try {
                                SO_CREATION_PREVENTER.add(object.getID());
                                this.protectedOnCreate(object);
                            }
                            finally {
                                SO_CREATION_PREVENTER.remove(object.getID());
                            }
                            return null;
                        }, TxExecutor.nestedWritableTransaction());
                    }
                    catch (Exception e) {
                        LOGGER.error("Object {} creation is failed", object, (Object)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(T object) {
        if (!SO_UPDATE_PREVENTER.contains(object.getID())) {
            Lock lock = (Lock)LOCK_STRIPED.get(object.getID());
            synchronized (lock) {
                if (!SO_UPDATE_PREVENTER.contains(object.getID())) {
                    try {
                        TxExecutor.execute(() -> {
                            try {
                                SO_UPDATE_PREVENTER.add(object.getID());
                                this.protectedOnUpdate(object);
                            }
                            finally {
                                SO_UPDATE_PREVENTER.remove(object.getID());
                            }
                            return null;
                        }, TxExecutor.nestedWritableTransaction());
                    }
                    catch (Exception e) {
                        LOGGER.error("Object {} updating is failed", object, (Object)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRemove(T object) {
        if (!SO_REMOVAL_PREVENTER.contains(object.getID())) {
            Lock lock = (Lock)LOCK_STRIPED.get(object.getID());
            synchronized (lock) {
                if (!SO_REMOVAL_PREVENTER.contains(object.getID())) {
                    try {
                        TxExecutor.execute(() -> {
                            try {
                                SO_REMOVAL_PREVENTER.add(object.getID());
                                this.protectedOnRemove(object);
                            }
                            finally {
                                SO_REMOVAL_PREVENTER.remove(object.getID());
                            }
                            return null;
                        }, TxExecutor.nestedWritableTransaction());
                    }
                    catch (Exception e) {
                        LOGGER.error("Object {} deletion is failed", object, (Object)e);
                    }
                }
            }
        }
    }

    protected void protectedOnCreate(T object) {
    }

    protected void protectedOnUpdate(T object) {
    }

    protected void protectedOnRemove(T object) {
    }

    @Override
    public void store(Storable storable) {
        try {
            TxExecutor.execute(() -> {
                Storable object = (Storable)this.repository.save(storable);
                storable.setVersion(object.getVersion());
                storable.setID(object.getID());
                return null;
            }, TxExecutor.defaultWritableTransaction());
        }
        catch (Exception e) {
            LOGGER.error("Error while object {} storing", (Object)storable, (Object)e);
        }
    }

    @Override
    public void replicate(Storable object) {
        try {
            ((Session)this.entityManager.getDelegate()).replicate((Object)object, ReplicationMode.OVERWRITE);
        }
        catch (Exception e) {
            LOGGER.error("Error while object {} replicating", (Object)object, (Object)e);
        }
    }

    @Override
    public void evict(Storable object) {
        ((Session)this.entityManager.getDelegate()).evict((Object)object);
    }

    @Override
    public void update(Storable object) {
        try {
            TxExecutor.execute(() -> {
                ((Session)this.entityManager.getDelegate()).update((Object)object);
                return null;
            }, TxExecutor.defaultWritableTransaction());
        }
        catch (Exception e) {
            LOGGER.error("Error while object {} updating", (Object)object, (Object)e);
        }
    }

    @Override
    public boolean contains(Storable object) {
        try {
            return TxExecutor.execute(() -> ((Session)this.entityManager.getDelegate()).contains((Object)object), TxExecutor.defaultWritableTransaction());
        }
        catch (Exception e) {
            LOGGER.error("Error while contains check {}: ", (Object)object, (Object)e);
            return false;
        }
    }

    @Override
    public void flush() {
        try {
            TxExecutor.execute(() -> {
                ((Session)this.entityManager.getDelegate()).flush();
                return null;
            }, TxExecutor.defaultWritableTransaction());
        }
        catch (Exception e) {
            LOGGER.error("Error while flush: ", (Throwable)e);
        }
    }

    @Override
    public T create() {
        try {
            return (T)((Storable)this.repository.save((Storable)this.myType.newInstance()));
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("Error while creating the storable: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T create(Storable parent) {
        try {
            return (T)((Storable)this.repository.save((Storable)this.myType.getConstructor(Storable.class).newInstance(parent)));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while creating the storable: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T create(Storable parent, String type) {
        try {
            return (T)((Storable)this.repository.save((Storable)this.myType.getConstructor(Storable.class, String.class).newInstance(parent, type)));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while creating the storable: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T create(Storable parent, String type, Map parameters) {
        try {
            return (T)((Storable)this.repository.save((Storable)this.myType.getConstructor(Storable.class, Map.class).newInstance(parent, parameters)));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while creating the storable: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T create(Storable parent, String name, String type) {
        try {
            return (T)((Storable)this.repository.save((Storable)this.myType.getConstructor(Storable.class, String.class, String.class).newInstance(parent, name, type)));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while creating the storable: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T create(Storable parent, String name, String type, String description) {
        try {
            return (T)((Storable)this.repository.save((Storable)this.myType.getConstructor(Storable.class, String.class, String.class, String.class).newInstance(parent, name, type, description)));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while creating the storable: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T create(Storable parent, String name, String type, String description, List<String> labels) {
        try {
            return (T)((Storable)this.repository.save((Storable)this.myType.getConstructor(Storable.class, String.class, String.class, String.class, List.class).newInstance(parent, name, type, description, labels)));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while creating the storable: ", (Throwable)e);
            return null;
        }
    }

    @Override
    @Nonnull
    public Storable copy(Storable dst, Storable obj, String projectId, String sessionId) throws CopyException {
        if (this.myType.isAssignableFrom(obj.getClass())) {
            return new StorableCopier(sessionId).copy(obj, dst, projectId, "copy");
        }
        throw new TypeMismatchException((Object)obj, this.myType);
    }

    @Override
    public void move(Storable dst, Storable obj, String sessionId) {
        if (!(obj instanceof OperationParsingRule || obj instanceof SystemTemplate || obj instanceof OperationTemplate)) {
            if (CoreObjectManager.getInstance().getManager(dst.getClass()).acceptsTo(obj) != null) {
                obj.setParent(dst);
                CoreObjectManager.getInstance().getManager(obj.getClass()).additionalMoveActions(obj, sessionId);
                this.store(obj);
            } else {
                throw new IllegalArgumentException(String.format("Destination %s cannot accept object %s", dst.getName(), obj.getName()));
            }
        }
    }

    @Override
    public void additionalMoveActions(Storable storable, String sessionId) {
    }

    @Override
    public Collection<UsageInfo> findUsages(Storable storable) {
        return null;
    }

    @Override
    public Map<String, List<BigInteger>> findImportantChildren(Storable storable) {
        return null;
    }

    @Override
    public String acceptsTo(Storable storable) {
        if (this.myType.isAssignableFrom(System.class)) {
            if (storable instanceof TransportConfiguration) {
                return "transports";
            }
            if (storable instanceof SystemParsingRule) {
                return "systemParsingRules";
            }
            if (storable instanceof Operation) {
                return "operations";
            }
            if (storable instanceof SystemTemplate) {
                return "systemTemplates";
            }
        } else if (this.myType.isAssignableFrom(CallChain.class)) {
            if (storable instanceof AbstractCallChainStep) {
                return "steps";
            }
        } else if (this.myType.isAssignableFrom(Operation.class)) {
            if (storable instanceof OperationParsingRule) {
                return "operationParsingRules";
            }
            if (storable instanceof OperationTemplate) {
                return "operationTemplates";
            }
            if (storable instanceof Situation) {
                return "situations";
            }
        } else if (this.myType.isAssignableFrom(StubProject.class)) {
            if (storable instanceof Environment) {
                return "environments";
            }
            if (storable instanceof DataSetListsSource) {
                return "dataSetLists";
            }
        } else if (this.myType.isAssignableFrom(Situation.class)) {
            if (storable instanceof IntegrationStep) {
                return "steps";
            }
            if (storable instanceof EventTrigger) {
                return "triggers";
            }
        } else if (this.myType.isAssignableFrom(Folder.class)) {
            if (storable instanceof Folder) {
                return "subFolders";
            }
            return "objects";
        }
        return null;
    }

    @Override
    public void setReplicationRole(String roleName) {
        throw new NotImplementedException("Not implemented yet");
    }

    private String generateName(@Nonnull Storable storable) {
        return "New " + storable.getClass().getSimpleName();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected static class RootRepositoryWrapper<T extends Storable>
    implements StorableRepository<T> {
        private final RootRepository<T> rootRepository;

        public RootRepositoryWrapper(RootRepository<T> rootRepository) {
            this.rootRepository = rootRepository;
        }

        @Override
        public List<T> findByParentIDAndName(Object parentId, String name) {
            return Collections.emptyList();
        }

        @Override
        public List<T> findByParentID(Object parentId) {
            return Collections.emptyList();
        }

        @Override
        public List<T> findByParentName(String name) {
            return Collections.emptyList();
        }

        @Override
        public List<T> findByName(String name) {
            return this.rootRepository.findByName(name);
        }

        @Override
        public List<T> findByNameContainingIgnoreCase(String name) {
            return this.rootRepository.findByNameContainingIgnoreCase(name);
        }

        @Override
        public List<T> findByNaturalId(String naturalId) {
            return this.rootRepository.findByNaturalId(naturalId);
        }

        public List<T> findAll() {
            return this.rootRepository.findAll();
        }

        public List<T> findAll(Sort sort) {
            return this.rootRepository.findAll(sort);
        }

        public Page<T> findAll(Pageable pageable) {
            return this.rootRepository.findAll(pageable);
        }

        public <S extends T> List<S> findAll(Example<S> example) {
            return this.rootRepository.findAll(example);
        }

        public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
            return this.rootRepository.findAll(example, sort);
        }

        public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
            return this.rootRepository.findAll(example, pageable);
        }

        public List<T> findAllById(Iterable<BigInteger> iterable) {
            return this.rootRepository.findAllById(iterable);
        }

        public long count() {
            return this.rootRepository.count();
        }

        public <S extends T> long count(Example<S> example) {
            return this.rootRepository.count(example);
        }

        public void deleteById(BigInteger bigInteger) {
            this.rootRepository.deleteById(bigInteger);
        }

        public void delete(T t) {
            this.rootRepository.delete(t);
        }

        public void deleteAllById(Iterable<? extends BigInteger> bigIntegers) {
        }

        public void deleteAll(Iterable<? extends T> iterable) {
            this.rootRepository.deleteAll(iterable);
        }

        public void deleteAll() {
            this.rootRepository.deleteAll();
        }

        public <S extends T> S save(S s) {
            return (S)((Storable)this.rootRepository.save(s));
        }

        public <S extends T> List<S> saveAll(Iterable<S> iterable) {
            return this.rootRepository.saveAll(iterable);
        }

        public Optional<T> findById(BigInteger bigInteger) {
            return this.rootRepository.findById(bigInteger);
        }

        public <S extends T> Optional<S> findOne(Example<S> example) {
            return this.rootRepository.findOne(example);
        }

        public boolean existsById(BigInteger bigInteger) {
            return this.rootRepository.existsById(bigInteger);
        }

        public <S extends T> boolean exists(Example<S> example) {
            return this.rootRepository.exists(example);
        }

        public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
            return null;
        }

        public void flush() {
            this.rootRepository.flush();
        }

        public <S extends T> S saveAndFlush(S s) {
            return (S)((Storable)this.rootRepository.saveAndFlush(s));
        }

        public <S extends T> List<S> saveAllAndFlush(Iterable<S> entities) {
            return null;
        }

        public void deleteInBatch(Iterable<T> iterable) {
            this.rootRepository.deleteInBatch(iterable);
        }

        public void deleteAllInBatch(Iterable<T> entities) {
        }

        public void deleteAllInBatch() {
            this.rootRepository.deleteAllInBatch();
        }

        public void deleteAllByIdInBatch(Iterable<BigInteger> bigIntegers) {
        }

        public T getOne(BigInteger bigInteger) {
            return (T)((Storable)this.rootRepository.getOne(bigInteger));
        }

        public T getById(BigInteger bigInteger) {
            return null;
        }

        public T getReferenceById(BigInteger bigInteger) {
            return null;
        }
    }
}

