/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.base;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Triple;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.constants.Match;
import org.qubership.automation.itf.core.util.exception.CopyException;

public interface ObjectManager<T extends Storable> {
    public Collection<? extends T> getAll();

    public T getById(@Nonnull Object var1);

    public Collection<? extends T> getByNatureId(@Nonnull Object var1, Object var2);

    public Collection<? extends T> getAllByParentId(@Nonnull Object var1);

    public Collection<? extends T> getByName(String var1);

    public Collection<? extends T> getByPieceOfName(String var1);

    public Collection<? extends T> getAllByParentName(String var1);

    public Collection<? extends T> getByProperties(BigInteger var1, Triple<String, Match, ?> ... var2);

    public Collection<? extends T> getByParentAndName(Storable var1, String var2);

    @Nullable
    public Collection<UsageInfo> remove(Storable var1, boolean var2);

    public void onCreate(T var1);

    public void onUpdate(T var1);

    public void onRemove(T var1);

    public void store(Storable var1);

    public void replicate(Storable var1);

    public boolean contains(Storable var1);

    public void update(Storable var1);

    public void flush();

    public void evict(Storable var1);

    public T create();

    public T create(Storable var1);

    public T create(Storable var1, String var2);

    public T create(Storable var1, String var2, Map var3);

    public T create(Storable var1, String var2, String var3);

    public T create(Storable var1, String var2, String var3, String var4);

    public T create(Storable var1, String var2, String var3, String var4, List<String> var5);

    public Storable copy(Storable var1, Storable var2, String var3, String var4) throws CopyException;

    public void move(Storable var1, Storable var2, String var3);

    @Nullable
    public Collection<UsageInfo> findUsages(Storable var1);

    public Map<String, List<BigInteger>> findImportantChildren(Storable var1);

    public String acceptsTo(Storable var1);

    public void additionalMoveActions(Storable var1, String var2);

    public void setReplicationRole(String var1);
}

