/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.StorableInFolderObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.BvCaseContainingObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.LabeledObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByParameterAndProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.CallChainRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.StepRepository;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CallChainObjectManager
extends AbstractObjectManager<CallChain, CallChain>
implements LabeledObjectManager<CallChain>,
BvCaseContainingObjectManager<CallChain>,
SearchByParameterAndProjectIdManager<CallChain>,
StorableInFolderObjectManager {
    private final StepRepository stepRepository;
    private final CallChainRepository callChainRepository;

    @Autowired
    public CallChainObjectManager(CallChainRepository repository, StepRepository stepRepository, CallChainRepository callChainRepository) {
        super(CallChain.class, repository);
        this.stepRepository = stepRepository;
        this.callChainRepository = callChainRepository;
    }

    @Override
    public void protectedOnRemove(CallChain object) {
        this.stepRepository.onDeleteCallChain(object);
    }

    @Override
    public Collection<UsageInfo> findUsages(Storable storable) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)50);
        CallChainObjectManager.addToUsages(result, "callChains", this.getCallChains((BigInteger)storable.getID()));
        return result;
    }

    private Iterable<CallChain> getCallChains(BigInteger id) {
        List<BigInteger> callChainsIds = this.callChainRepository.getIdsCallchains(id);
        ArrayList callChains = Lists.newArrayListWithCapacity((int)callChainsIds.size());
        if (!callChainsIds.isEmpty()) {
            for (BigInteger callChainId : callChainsIds) {
                CallChain callChain = (CallChain)this.callChainRepository.getOne(callChainId);
                callChains.add(callChain);
            }
        }
        return callChains;
    }

    @Override
    @Deprecated
    public Collection<? extends CallChain> getByLabel(String label) {
        return null;
    }

    @Override
    public Collection<CallChain> getByLabel(String label, BigInteger projectId) {
        Collection ids = TxExecutor.executeUnchecked(() -> this.callChainRepository.getCallchainIdsByLabel(label, projectId), TxExecutor.readOnlyTransaction());
        ArrayList callChainsByLabel = Lists.newArrayList();
        if (ids != null) {
            for (BigInteger id : ids) {
                callChainsByLabel.add(this.callChainRepository.getOne(id));
            }
        }
        return callChainsByLabel;
    }

    public List<IdNamePair> getSimpleListByProject(BigInteger projectId) {
        return TxExecutor.executeUnchecked(() -> this.callChainRepository.getSimpleListByProject(projectId), TxExecutor.readOnlyTransaction());
    }

    @Override
    public int countBvCaseUsages(String bvCaseId) {
        return TxExecutor.executeUnchecked(() -> this.callChainRepository.countBvCaseUsages(bvCaseId), TxExecutor.readOnlyTransaction());
    }

    @Override
    public Set<String> getAllLabels(BigInteger projectId) {
        return TxExecutor.executeUnchecked(() -> this.callChainRepository.getAllLabels(projectId), TxExecutor.readOnlyTransaction());
    }

    @Override
    public List<CallChain> getByNameAndProjectId(String name, BigInteger projectId) {
        return this.callChainRepository.findByNameAndProjectId(name, projectId);
    }

    public List<CallChain> getByPieceOfNameAndProjectId(String name, BigInteger projectId) {
        return this.callChainRepository.findByPieceOfNameAndProjectId(name, projectId);
    }

    @Override
    public Collection<CallChain> getByProjectId(BigInteger projectId) {
        return this.callChainRepository.findByProjectId(projectId);
    }

    @Override
    public List<Object[]> getObjectsWithBvLinks(BigInteger projectId) {
        return new ArrayList<Object[]>();
    }

    @Override
    public List<?> getReceiverSystemsFromCallChainSteps(Object chainId) {
        throw new NotImplementedException("Method getReceiverSystemsFromCallChainSteps is not implemented");
    }

    public List<Object[]> getAllIdsAndNamesByProjectId(BigInteger projectId) {
        return this.stepRepository.findIdAndNameByProjectId(IdConverter.toBigInt(projectId));
    }

    @Override
    public void afterDelete(Storable object) {
        this.afterDeleteFromFolder(object);
    }
}

