/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.CounterRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.counter.Counter;
import org.qubership.automation.itf.core.model.counter.CounterImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CounterObjectManager
extends AbstractObjectManager<Counter, Counter> {
    private Map<String, Class<? extends Counter>> subclasses;

    @Autowired
    public CounterObjectManager(CounterRepository repository) {
        super(Counter.class, repository);
    }

    @Override
    public Counter create(Storable parent, String type, Map parameters) {
        Counter result;
        Class<? extends Counter> counterClass = this.subclasses.get(type);
        if (counterClass == null) {
            throw new IllegalArgumentException("Cannot create counter of type " + type);
        }
        try {
            result = counterClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot create counter of type " + type + " with class " + counterClass.getCanonicalName(), e);
        }
        result = (Counter)this.repository.save(result);
        result.setIndex(0);
        return result;
    }

    @Override
    protected void protectedOnRemove(Counter object) {
    }

    @PostConstruct
    protected void init() {
        this.subclasses = new HashMap<String, Class<? extends Counter>>(){
            {
                this.put(CounterImpl.class.getName(), CounterImpl.class);
            }
        };
    }
}

