/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.NotImplementedException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.StorableInFolderObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ByProject;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvConfigurationManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvironmentManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByParameterAndProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.EnvironmentRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.report.LinkCollectorConfiguration;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentObjectManager
extends AbstractObjectManager<Environment, Environment>
implements EnvironmentManager,
EnvConfigurationManager<Environment>,
ByProject<Environment>,
SearchByParameterAndProjectIdManager<Environment>,
StorableInFolderObjectManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentObjectManager.class);
    private final EnvironmentRepository environmentRepository;

    @Autowired
    public EnvironmentObjectManager(EnvironmentRepository repository) {
        super(Environment.class, repository);
        this.environmentRepository = repository;
    }

    @Override
    public void updateInitialEnvState() {
        LOGGER.info("Triggers' and Environments' statuses initial setup is started.");
        TxExecutor.executeUnchecked(this.environmentRepository::turnOffLostTriggers, TxExecutor.defaultWritableTransaction());
        LOGGER.info("Triggers' and Environments' statuses initial setup is done.");
    }

    @Override
    public Environment getByEcId(@Nonnull String ecId, Object ... objects) {
        return TxExecutor.executeUnchecked(() -> this.environmentRepository.findEnvironmentByEcId(ecId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public Collection<Environment> getByEcProjectId(String ecProjectId) {
        return TxExecutor.executeUnchecked(() -> this.environmentRepository.getEnvironmentsByEcProject(ecProjectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public Collection<String> getEcProjectIds(BigInteger projectId) {
        return TxExecutor.executeUnchecked(() -> this.environmentRepository.getEcProjectIds(projectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public void unbindByEcProject(String ecProjectId) {
        TxExecutor.executeUnchecked(() -> this.environmentRepository.unbindByEcProject(ecProjectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public Environment findByEcLabel(String ecLabel, BigInteger projectId) {
        return null;
    }

    @Override
    public List<Environment> getByNameAndProjectId(String name, BigInteger projectId) {
        return this.environmentRepository.findByNameAndProjectId(name, projectId);
    }

    public List<Environment> getByPieceOfNameAndProjectId(String name, BigInteger projectId) {
        return this.environmentRepository.findByPieceOfNameAndProjectId(name, projectId);
    }

    @Override
    public Collection<Environment> getByProjectId(BigInteger projectId) {
        return this.environmentRepository.findByProjectId(projectId);
    }

    @Override
    public List<Object[]> getByServerAndSystemIdPair(@Nonnull BigInteger systemId, @Nonnull BigInteger serverId) {
        return TxExecutor.executeUnchecked(() -> this.environmentRepository.findEnvironmentByServerAndSystemIdPair(systemId, serverId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public Collection<String> findEnvironmentEcIdsForSystem(BigInteger systemId) {
        return TxExecutor.executeUnchecked(() -> this.environmentRepository.findEnvironmentEcIdsForSystem(systemId), TxExecutor.readOnlyTransaction());
    }

    @Override
    public Collection<String> findEnvironmentEcIdsForServer(BigInteger serverId) {
        return TxExecutor.executeUnchecked(() -> this.environmentRepository.findEnvironmentEcIdsForServer(serverId), TxExecutor.readOnlyTransaction());
    }

    @Override
    public Environment findByServerAndSystems(BigInteger serverId, Collection<BigInteger> systemIds) {
        List<BigInteger> envIds = this.environmentRepository.findByServerAndSystems(serverId, systemIds);
        return envIds == null || envIds.isEmpty() ? null : (Environment)this.environmentRepository.findById(envIds.get(0)).get();
    }

    @Override
    public Collection<Environment> getAllByProject(Object projectId) {
        throw new NotImplementedException("Not implemented for project");
    }

    @Override
    public Collection<Environment> getByPieceOfNameAndProject(String name, Object projectId) {
        throw new NotImplementedException("Not implemented method");
    }

    @Override
    public Collection<Environment> getByParentNameAndProject(String name, Object projectId) {
        throw new NotImplementedException("Not implemented method");
    }

    public String getEnvironmentStateById(String environmentId) {
        return this.environmentRepository.getEnvironmentState(IdConverter.toBigInt(environmentId));
    }

    public Set<LinkCollectorConfiguration> getLinkCollectorsByEnvId(BigInteger environmentId) {
        return this.environmentRepository.getLinkCollectorsByEnvId(environmentId);
    }

    @Override
    public List<String> getInboundInfo(BigInteger envId) {
        return this.environmentRepository.getInboundInfo(envId);
    }

    @Override
    public void afterDelete(Storable object) {
        this.afterDeleteFromFolder(object);
    }
}

