/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.FolderManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.FolderRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.folder.ChainFolder;
import org.qubership.automation.itf.core.model.jpa.folder.DsListFolder;
import org.qubership.automation.itf.core.model.jpa.folder.EnvFolder;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.folder.ServerFolder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.util.copier.StorableCopier;
import org.qubership.automation.itf.core.util.exception.CopyException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FolderObjectManager
extends AbstractObjectManager<Folder, Folder>
implements FolderManager {
    private final FolderRepository folderRepository;
    private Map<String, Class<? extends Folder>> subclasses;

    @Autowired
    public FolderObjectManager(FolderRepository repository) {
        super(Folder.class, repository);
        this.folderRepository = repository;
    }

    @Override
    public Folder create(Storable parent, String name, String type) {
        Folder result;
        Class<? extends Folder> folderClass = this.subclasses.get(type);
        if (folderClass == null) {
            throw new IllegalArgumentException("Cannot create folder of type " + type);
        }
        try {
            result = folderClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot create folder of type " + type + " with class " + folderClass.getCanonicalName(), e);
        }
        Folder parentFolder = null;
        if (parent instanceof Folder) {
            parentFolder = (Folder)parent;
        }
        result.setParent(parentFolder);
        result.setTypeName(type);
        result.setName(name);
        result = (Folder)this.repository.save(result);
        if (parentFolder != null) {
            parentFolder.getSubFolders().add(result);
        }
        return result;
    }

    @Override
    public Folder create() {
        throw new IllegalArgumentException("Cannot create step of unknown type!");
    }

    @PostConstruct
    protected void init() {
        this.subclasses = new HashMap<String, Class<? extends Folder>>(){
            {
                this.put(EnvFolder.TYPE.getSimpleName(), EnvFolder.class);
                this.put(ChainFolder.TYPE.getSimpleName(), ChainFolder.class);
                this.put(DsListFolder.TYPE.getSimpleName(), DsListFolder.class);
                this.put(ServerFolder.TYPE.getSimpleName(), ServerFolder.class);
                this.put(SystemFolder.TYPE.getSimpleName(), SystemFolder.class);
            }
        };
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only Folder objects are here")
    public Storable copy(Storable dst, Storable obj, String projectId, String sessionId) throws CopyException {
        Folder sourceFolder = (Folder)obj;
        Storable folderCopy = super.copy(dst, obj, projectId, sessionId);
        for (Storable storable : sourceFolder.getObjects()) {
            StorableCopier storableCopier = new StorableCopier(sessionId);
            storableCopier.copy(storable, folderCopy, projectId, "copy");
        }
        for (Folder folder : ((Folder)obj).getSubFolders()) {
            if (folder.getID().equals(folderCopy.getID())) continue;
            this.copy(folderCopy, folder, projectId, sessionId);
        }
        return folderCopy;
    }

    @Override
    public List<Folder> findFolderByPieceOfName(String classShortName, String pieceOfName, BigInteger projectId) {
        switch (classShortName) {
            case "ChainFolder": {
                return this.folderRepository.findFolderByProjectAndNameContainingIgnoreCase(pieceOfName, projectId, "chains");
            }
            case "EnvFolder": {
                return this.folderRepository.findFolderByProjectAndNameContainingIgnoreCase(pieceOfName, projectId, "envs");
            }
            case "SystemFolder": {
                return this.folderRepository.findFolderByProjectAndNameContainingIgnoreCase(pieceOfName, projectId, "systems");
            }
        }
        return new ArrayList<Folder>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterDelete(Storable object) {
        if (object.getParent() instanceof Folder) {
            Storable storable = object.getParent();
            synchronized (storable) {
                ((Folder)object.getParent()).getSubFolders().remove(object);
            }
        }
    }
}

