/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.querydsl.core.types.Predicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.StorableInFolderObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvConfigurationManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByUrlAndProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.EnvironmentRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.InboundTransportConfigurationRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.OutboundTransportConfigurationRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.ServerRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.QEnvironment;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.project.StubContainer;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.server.ServerHB;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerObjectManager
extends AbstractObjectManager<Server, ServerHB>
implements EnvConfigurationManager<Server>,
SearchByUrlAndProjectIdManager<Server>,
StorableInFolderObjectManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerObjectManager.class);
    public static ServerObjectManager INSTANCE;
    private final InboundTransportConfigurationRepository inboundTransportRepository;
    private final OutboundTransportConfigurationRepository outboundTransportRepository;
    private final EnvironmentRepository environmentRepository;
    private final ServerRepository serverRepository;

    @Autowired
    public ServerObjectManager(ServerRepository repository, InboundTransportConfigurationRepository inbRep, OutboundTransportConfigurationRepository outbRep, EnvironmentRepository environmentRepository) {
        super(Server.class, repository);
        this.serverRepository = repository;
        this.inboundTransportRepository = inbRep;
        this.outboundTransportRepository = outbRep;
        this.environmentRepository = environmentRepository;
        INSTANCE = this;
    }

    @Override
    public void protectedOnRemove(Server object) {
        HashSet toRemove;
        Iterable environments = this.environmentRepository.findAll((Predicate)QEnvironment.environment.outbound.containsValue((Object)object));
        for (Environment environment : environments) {
            toRemove = Sets.newHashSetWithExpectedSize((int)environment.getOutbound().size());
            for (Map.Entry<System, Server> entry : environment.getOutbound().entrySet()) {
                if (!entry.getValue().getID().equals(object.getID())) continue;
                toRemove.add(entry.getKey());
            }
            for (System system : toRemove) {
                environment.getOutbound().remove(system);
            }
            environment.store();
        }
        environments = this.environmentRepository.findAll((Predicate)QEnvironment.environment.inbound.containsValue((Object)object));
        for (Environment environment : environments) {
            toRemove = Sets.newHashSetWithExpectedSize((int)environment.getInbound().size());
            for (Map.Entry<System, Server> entry : environment.getInbound().entrySet()) {
                if (!entry.getValue().getID().equals(object.getID())) continue;
                toRemove.add(entry.getKey());
            }
            for (System system : toRemove) {
                environment.getInbound().remove(system);
            }
            environment.store();
        }
    }

    @Override
    public Server create(Storable parent) {
        Optional<Folder<Server>> serverFolder;
        Folder actualParent = null;
        if (parent instanceof StubContainer) {
            actualParent = ((StubContainer)((Object)parent)).getServers();
        } else if (parent instanceof Folder && (serverFolder = ((Folder)parent).of(Server.class)).isPresent()) {
            actualParent = (Folder)serverFolder.get();
        }
        if (actualParent == null) {
            throw new RuntimeException("ER: ServerFolder or StubContainer; AR: " + parent);
        }
        ServerHB result = new ServerHB();
        result.setParent(actualParent);
        result.setProjectId(actualParent.getProjectId());
        actualParent.getObjects().add(result);
        return (Server)this.repository.save(result);
    }

    @Override
    public Server create() {
        ServerHB result = new ServerHB();
        return (Server)this.repository.save(result);
    }

    public OutboundTransportConfiguration getOutbound(Server server, System system, String type) {
        try {
            return this.outboundTransportRepository.findOne((BigInteger)system.getID(), (BigInteger)server.getID(), type);
        }
        catch (Exception e) {
            LOGGER.error("Can't get outbound configuration for Server: {}, System {} and type '{}'", new Object[]{server, system, type, e});
            throw e;
        }
    }

    public Iterable<OutboundTransportConfiguration> getOutbounds(Server server, System system) {
        return this.outboundTransportRepository.findAll((BigInteger)system.getID(), (BigInteger)server.getID());
    }

    public InboundTransportConfiguration getInbound(Server server, TransportConfiguration configuration) {
        return this.inboundTransportRepository.findOne((BigInteger)server.getID(), (BigInteger)configuration.getID());
    }

    public Iterable<InboundTransportConfiguration> getInbounds(Server server, System system) {
        return this.inboundTransportRepository.findAll((BigInteger)server.getID(), (BigInteger)system.getID());
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only Server objects are here")
    public Collection<UsageInfo> findUsages(Storable storable) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)20);
        Iterable environments = this.environmentRepository.findAll((Predicate)QEnvironment.environment.outbound.containsValue((Object)((Server)storable)));
        ServerObjectManager.addToUsages(result, "outbound", environments);
        environments = this.environmentRepository.findAll((Predicate)QEnvironment.environment.inbound.containsValue((Object)((Server)storable)));
        ServerObjectManager.addToUsages(result, "inbound", environments);
        return result;
    }

    @Override
    public Map<String, List<BigInteger>> findImportantChildren(Storable storable) {
        if (storable instanceof Server) {
            List<BigInteger> stubTriggerIds = this.serverRepository.getTransportTriggersByServerId(IdConverter.toBigInt(storable.getID()));
            HashMap<String, List<BigInteger>> result = new HashMap<String, List<BigInteger>>();
            result.put("TransportTriggers", stubTriggerIds);
            return result;
        }
        return super.findImportantChildren(storable);
    }

    @Override
    public Server getByEcId(@Nonnull String ecId, Object ... objects) {
        return TxExecutor.executeUnchecked(() -> this.serverRepository.findByEcId(ecId, (String)objects[0], (String)objects[1]), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public Collection<Server> getByEcProjectId(String ecProjectId) {
        return TxExecutor.executeUnchecked(() -> this.serverRepository.getByEcProject(ecProjectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public Collection<String> getEcProjectIds(BigInteger projectId) {
        return TxExecutor.executeUnchecked(() -> this.serverRepository.getEcProjectIds(projectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public void unbindByEcProject(String ecProjectId) {
        TxExecutor.executeUnchecked(() -> this.serverRepository.unbindByEcProject(ecProjectId), TxExecutor.defaultWritableTransaction());
    }

    @Override
    public Server findByEcLabel(String ecLabel, BigInteger projectId) {
        return null;
    }

    @Override
    public List<Server> getByUrlAndProjectId(String url, BigInteger projectId) {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.serverRepository.findByUrlAndProjectId(url, projectId));
        return result;
    }

    @Override
    public List<Server> getByUrlSlashedAndProjectId(String url, BigInteger projectId) {
        List<BigInteger> ids = this.serverRepository.getServersByProjectAndUrlSlashed(url.endsWith("/") ? url : url + "/", projectId);
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<Server>();
        }
        ArrayList<Server> servers = new ArrayList<Server>();
        for (BigInteger id : ids) {
            if (id == null) continue;
            Server server = (Server)this.serverRepository.getOne(id);
            servers.add(server);
        }
        return servers;
    }

    @Override
    public List<Server> getByNameAndProjectId(String name, BigInteger projectId) {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.serverRepository.findByNameAndProjectId(name, projectId));
        return result;
    }

    @Override
    public List<Server> getByProjectId(BigInteger projectId) {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.serverRepository.findByProjectId(projectId));
        return result;
    }

    @Override
    public void afterDelete(Storable object) {
        this.afterDeleteFromFolder(object);
    }

    public int deleteUnusedOutboundConfigurations() {
        return ((ServerRepository)this.repository).deleteUnusedOutboundConfigurations();
    }

    public int deleteUnusedOutboundConfigurationsByProjectId(BigInteger projectId) {
        return ((ServerRepository)this.repository).deleteUnusedOutboundConfigurationsByProjectId(projectId);
    }
}

