/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.EventTriggerManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.EventTriggerObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.SituationEventTriggerRepository;
import org.qubership.automation.itf.core.model.communication.EventTriggerBriefInfo;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SituationEventTriggerObjectManager
extends EventTriggerObjectManager<SituationEventTrigger>
implements EventTriggerManager<SituationEventTrigger>,
SearchByProjectIdManager<SituationEventTrigger> {
    @Autowired
    public SituationEventTriggerObjectManager(SituationEventTriggerRepository repository) {
        super(SituationEventTrigger.class, repository);
    }

    @Override
    public Collection<SituationEventTrigger> getByProjectId(BigInteger projectId) {
        return ((SituationEventTriggerRepository)this.repository).findByProject(projectId);
    }

    @Override
    public List<SituationEventTrigger> getAllActive(@NotNull Operation operation) {
        return new ArrayList<SituationEventTrigger>();
    }

    @Override
    public List<SituationEventTrigger> getActiveByProject(@NotNull BigInteger projectId) {
        return ((SituationEventTriggerRepository)this.repository).getActiveTriggersByProject(projectId);
    }

    public List<SituationEventTrigger> getTriggersBySystem(@NotNull BigInteger systemId) {
        return ((SituationEventTriggerRepository)this.repository).getTriggersBySystemId(systemId);
    }

    public Map<String, List<EventTriggerBriefInfo>> getTriggersBriefInfoBySystem(@NotNull BigInteger systemId) {
        List<Object[]> objs = ((SituationEventTriggerRepository)this.repository).getTriggersBriefInfoBySystemId(systemId);
        ArrayList<EventTriggerBriefInfo> triggersToDeactivate = new ArrayList<EventTriggerBriefInfo>();
        ArrayList<EventTriggerBriefInfo> triggersToReactivate = new ArrayList<EventTriggerBriefInfo>();
        if (objs != null && !objs.isEmpty()) {
            for (Object[] entry : objs) {
                if (entry.length < 2) continue;
                EventTriggerBriefInfo briefInfo = new EventTriggerBriefInfo((BigInteger)entry[0], "Situation Event Trigger");
                if ("ACTIVE".equals(entry[1].toString())) {
                    triggersToReactivate.add(briefInfo);
                    continue;
                }
                triggersToDeactivate.add(briefInfo);
            }
        }
        HashMap<String, List<EventTriggerBriefInfo>> triggersToSync = new HashMap<String, List<EventTriggerBriefInfo>>();
        triggersToSync.put("ToDeactivate", triggersToDeactivate);
        triggersToSync.put("ToReactivate", triggersToReactivate);
        return triggersToSync;
    }

    public SituationEventTrigger getByIdOnly(BigInteger id) {
        return ((SituationEventTriggerRepository)this.repository).findByIdOnly(id);
    }
}

