/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.reports;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.InstanceManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.reports.AbstractInstanceRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.generator.id.UniqueIdGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AbstractInstanceObjectManager<T extends AbstractInstance>
extends AbstractObjectManager<AbstractInstance, AbstractInstance>
implements InstanceManager {
    private Map<String, Class<? extends AbstractInstance>> subclasses;

    @Autowired
    public AbstractInstanceObjectManager(AbstractInstanceRepository repository) {
        super(AbstractInstance.class, repository);
    }

    @Override
    public void protectedOnRemove(AbstractInstance object) {
    }

    @Override
    public AbstractInstance create(Storable parent, String type, Map parameters) {
        return this.createInMemory(parent, type, parameters, true);
    }

    @Override
    public AbstractInstance create() {
        throw new IllegalArgumentException("Cannot create instance of unknown type!");
    }

    private AbstractInstance createInMemory(Storable parent, String type, Map parameters, boolean setId) {
        AbstractInstance result;
        Class<? extends AbstractInstance> instanceClass = this.subclasses.get(type);
        if (null == instanceClass) {
            throw new IllegalArgumentException("Cannot create instance of type " + type);
        }
        try {
            result = instanceClass.newInstance();
            if (setId) {
                result.setID(UniqueIdGenerator.generate());
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot create instance of type " + type + " with class " + instanceClass.getCanonicalName(), e);
        }
        result.setParent(parent);
        return result;
    }

    @PostConstruct
    protected void init() {
        this.subclasses = new HashMap<String, Class<? extends AbstractInstance>>(){
            {
                this.put(CallChainInstance.class.getSimpleName(), CallChainInstance.class);
                this.put(SituationInstance.class.getSimpleName(), SituationInstance.class);
                this.put(StepInstance.class.getSimpleName(), StepInstance.class);
            }
        };
    }

    @Override
    public void storeInNestedTransaction(Storable storable) {
        TxExecutor.executeUnchecked(() -> {
            AbstractInstance object = (AbstractInstance)this.repository.save((AbstractInstance)storable);
            storable.setVersion(object.getVersion());
            storable.setID(object.getID());
            return object;
        }, TxExecutor.nestedWritableTransaction());
    }

    public T getByIDAndPartNum(BigInteger id, Integer partNum) {
        return ((AbstractInstanceRepository)this.repository).findByIDAndPartNum(id, partNum);
    }
}

