/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.reports;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ContextManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.reports.TcContextBriefInfoRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.reports.TcContextRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TcContextObjectManager
extends AbstractObjectManager<TcContext, TcContext>
implements ContextManager,
SearchByProjectIdManager<TcContext> {
    private final TcContextRepository tcContextRepository;
    private final TcContextBriefInfoRepository tcContextBriefInfoRepository;

    @Autowired
    public TcContextObjectManager(TcContextRepository repository, TcContextBriefInfoRepository tcContextBriefInfoRepository) {
        super(TcContext.class, repository);
        this.tcContextRepository = repository;
        this.tcContextBriefInfoRepository = tcContextBriefInfoRepository;
    }

    @Override
    public void store(Storable storable) {
        TxExecutor.executeUnchecked(() -> {
            TcContext tcContext = (TcContext)this.tcContextRepository.save((TcContext)storable);
            storable.setVersion(tcContext.getVersion());
            storable.setID(tcContext.getID());
            return tcContext;
        }, TxExecutor.nestedWritableTransaction());
    }

    @Override
    public TcContext create(Storable parent, String type, Map parameters) {
        return this.create();
    }

    @Override
    public TcContext create() {
        return TxExecutor.executeUnchecked(() -> (TcContext)TcContextObjectManager.super.create(), TxExecutor.nestedWritableTransaction());
    }

    @Override
    @Nonnull
    public Storable copy(Storable dst, Storable obj, String projectId, String sessionId) {
        throw new UnsupportedOperationException("Cannot copy TcContext");
    }

    @Override
    public void move(Storable dst, Storable obj, String sessionId) {
        throw new UnsupportedOperationException("Cannot move TcContext");
    }

    @Override
    public String acceptsTo(Storable storable) {
        throw new UnsupportedOperationException("TcContext cannot accept copy/move of other objects");
    }

    @Override
    public void protectedOnRemove(TcContext object) {
    }

    @Transactional
    public int updateStatusContextWithStatusInProgress() {
        return this.tcContextRepository.updateStatusContextWithStatusInProgress();
    }

    @Override
    public String clearMonitoringData(int clearHours) {
        return this.tcContextRepository.clearMonitoringData(clearHours);
    }

    @Override
    public void deleteById(String id, Integer partNum) {
        if (!StringUtils.isBlank((CharSequence)id)) {
            if (partNum == null) {
                this.tcContextBriefInfoRepository.deleteFromUIWithoutPartNum(IdConverter.toBigInt(id));
            } else {
                this.tcContextBriefInfoRepository.deleteFromUIWithPartNum(IdConverter.toBigInt(id), partNum);
            }
        }
    }

    @Override
    public Collection<TcContext> getByProjectId(BigInteger projectId) {
        return this.tcContextRepository.findByProjectId(projectId);
    }
}

