/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.SearchRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.report.LinkCollectorConfiguration;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EnvironmentRepository
extends SearchRepository<Environment>,
QuerydslPredicateExecutor<Environment>,
StorableRepository<Environment> {
    @Modifying
    @Query(value="update mb_env set state = case when id in (select distinct get_env(id) from mb_configuration where \"type\"='trigger') then 'INACTIVE' else 'EMPTY' end; commit;", nativeQuery=true)
    public void setInitialEnvStateInactiveOrEmpty();

    @Modifying
    @Query(value="update mb_configuration set trigger_state = 'INACTIVE', activation_error_message = null where \"type\"='trigger' and id not in (select get_all_env_triggers(id) from mb_env); commit;", nativeQuery=true)
    public void turnOffLostTriggers();

    @Query(value="select state from mb_env where id = :envId", nativeQuery=true)
    public String getEnvironmentState(@Param(value="envId") BigInteger var1);

    @Query(value="select env from Environment env where env.ecId = :ecId")
    public Environment findEnvironmentByEcId(@Param(value="ecId") String var1);

    @Query(value="select ec_project_id from mb_env where ec_project_id is not null and project_id = :projectId group by ec_project_id", nativeQuery=true)
    public Collection<String> getEcProjectIds(@Param(value="projectId") BigInteger var1);

    @Query(value="select environment from Environment environment where environment.ecProjectId = :ecProjectId")
    public Collection<Environment> getEnvironmentsByEcProject(@Param(value="ecProjectId") String var1);

    @Modifying
    @Query(value="update mb_env set ec_project_id = null, ec_id = null where ec_project_id = :ecProjectId", nativeQuery=true)
    public void unbindByEcProject(@Param(value="ecProjectId") String var1);

    @Query(value="select environment_id, mb_env.\"name\" from mb_env_inbound   inner join mb_env on environment_id=mb_env.id   where systems = :systemId and servers = :serverId", nativeQuery=true)
    public List<Object[]> findEnvironmentByServerAndSystemIdPair(@Param(value="systemId") BigInteger var1, @Param(value="serverId") BigInteger var2);

    @Query(value="with system_info as (select cast(:systemId as BIGINT) as id)\nselect distinct on (t.environment_id) e.ec_id from (  select environment_id   from mb_env_inbound   where systems in (select id from system_info)   union all   select environment_id   from mb_env_outbound   where systems in (select id from system_info) ) t join mb_env e on t.environment_id = e.id where e.ec_id is not null", nativeQuery=true)
    public Collection<String> findEnvironmentEcIdsForSystem(@Param(value="systemId") BigInteger var1);

    @Query(value="with server_info as (select cast(:serverId as BIGINT) as id) select distinct on (t.environment_id) e.ec_id from (   select environment_id   from mb_env_inbound   where servers in (select id from server_info)   union all   select environment_id   from mb_env_outbound   where servers in (select id from server_info) ) t join mb_env e on t.environment_id = e.id where e.ec_id is not null", nativeQuery=true)
    public Collection<String> findEnvironmentEcIdsForServer(@Param(value="serverId") BigInteger var1);

    @Query(value="select env from Environment env where lower(env.name) like concat('%', lower(:name), '%')  and env.projectId = :projectId")
    public List<Environment> findByPieceOfNameAndProjectId(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Override
    public List<Environment> findByNameAndProjectId(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select environment_id from mb_env_outbound where servers=:serverId and systems in :systemIds", nativeQuery=true)
    public List<BigInteger> findByServerAndSystems(@Param(value="serverId") BigInteger var1, @Param(value="systemIds") Collection<BigInteger> var2);

    @Query(value="select jsonb_build_object( 'system_server', t.system_server, 'transports', json_agg(t.transports_info) )\\:\\:text from  ( select  systems.name||' / '||servers.name as system_server, jsonb_build_object( 'transport_name', transport.name, 'triggers', json_agg( jsonb_build_object( 'trigger_id', transport_trigger.id, 'trigger_name', case when transport_trigger.name is not null then transport_trigger.name else '[ID='||transport_trigger.id||']' end, 'trigger_state', transport_trigger.trigger_state ) ) ) as transports_info from  mb_env_inbound env_inbound inner join  mb_systems systems on systems.id = env_inbound.systems inner join  mb_servers servers on servers.id = env_inbound.servers inner join  mb_configuration inbound_transport_config on  inbound_transport_config.parent_in_server_id = env_inbound.servers inner join  mb_configuration transport on  transport.id = inbound_transport_config.transport_id and  transport.parent_system_id = env_inbound.systems left join  mb_configuration transport_trigger on  transport_trigger.parent_conf_id = inbound_transport_config.id where  env_inbound.environment_id = :envId group by  transport.id, systems.name||' / '||servers.name ) t group by t.system_server", nativeQuery=true)
    public List<String> getInboundInfo(@Param(value="envId") BigInteger var1);

    @Query(value="select env.reportCollectors from Environment env where env.id = :envId")
    public Set<LinkCollectorConfiguration> getLinkCollectorsByEnvId(@Param(value="envId") BigInteger var1);
}

