/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InboundTransportConfigurationRepository
extends StorableRepository<InboundTransportConfiguration>,
QuerydslPredicateExecutor<InboundTransportConfiguration> {
    @Modifying
    @Query(value="delete from InboundTransportConfiguration i where i.referencedConfiguration = :configuration")
    public void onDeleteTransport(@Param(value="configuration") TransportConfiguration var1);

    @Query(value="select i from TransportConfiguration i where i.id = :id")
    public TransportConfiguration findFirstTransport(@Param(value="id") BigInteger var1);

    @Query(value="select i.transport_id from mb_configuration i where i.id =  :parent", nativeQuery=true)
    public Object getIdByTransport(@Param(value="parent") BigInteger var1);

    @Query(value="select itc from InboundTransportConfiguration itc where itc.ecId = :ecId")
    public InboundTransportConfiguration findByEcId(@Param(value="ecId") String var1);

    @Query(value="select ec_project_id from mb_configuration where type='inbound' and ec_project_id is not null and parent_in_server_id in (select id from mb_servers where project_id = :projectId) group by ec_project_id", nativeQuery=true)
    public Collection<String> getEcProjectIds(@Param(value="projectId") BigInteger var1);

    @Query(value="select itc from InboundTransportConfiguration itc where itc.ecProjectId = :ecProjectId")
    public Collection<InboundTransportConfiguration> getByEcProject(@Param(value="ecProjectId") String var1);

    @Modifying
    @Query(value="update mb_configuration set ec_project_id = null, ec_id = null where ec_project_id = :ecProjectId and type='inbound'", nativeQuery=true)
    public void unbindByEcProject(@Param(value="ecProjectId") String var1);

    @Query(value="select inb_conf.*  from mb_configuration inb_conf where inb_conf.type = 'inbound' and inb_conf.parent_in_server_id = :serverId and inb_conf.transport_id = :transportId", nativeQuery=true)
    public InboundTransportConfiguration findOne(@Param(value="serverId") BigInteger var1, @Param(value="transportId") BigInteger var2);

    @Query(value="select inb_conf.*  from mb_configuration inb_conf, mb_configuration tr_conf where inb_conf.type = 'inbound' and inb_conf.parent_in_server_id = :serverId and tr_conf.id = inb_conf.transport_id and tr_conf.parent_system_id = :systemId", nativeQuery=true)
    public Iterable<InboundTransportConfiguration> findAll(@Param(value="serverId") BigInteger var1, @Param(value="systemId") BigInteger var2);

    @Query(value="select itc from InboundTransportConfiguration itc where itc.referencedConfiguration.id = :transportId")
    public Collection<InboundTransportConfiguration> getConfigurationsByTransportId(@Param(value="transportId") BigInteger var1);
}

