/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import javax.persistence.QueryHint;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.TemplateRepository;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@JaversSpringDataAuditable
public interface OperationTemplateRepository
extends TemplateRepository<Operation, OperationTemplate> {
    @Override
    @Query(value="select operationTemplate from OperationTemplate as operationTemplate inner join Operation as operation on operation = operationTemplate.parent where operationTemplate.name = :name and operation.ID = :parentId")
    public List<OperationTemplate> findByParentIDAndName(@Param(value="parentId") Object var1, @Param(value="name") String var2);

    @Override
    @Query(value="select template.* from mb_templates template where template.type = 'operation' and template.parent_operation_id = :parentId", nativeQuery=true)
    public List<OperationTemplate> findByParentID(@Param(value="parentId") Object var1);

    @Override
    @Query(value="select operationTemplate from OperationTemplate as operationTemplate inner join Operation as operation on operation = operationTemplate.parent where operation.name = :name")
    public List<OperationTemplate> findByParentName(@Param(value="name") String var1);

    @Query(value="select template from OperationTemplate template inner join Operation as operation on operation = template.parent where lower(operation.name) like concat('%', lower(:name), '%') and operation.projectId = :projectId")
    public Collection<OperationTemplate> findByParentNameAndProject(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select t from OperationTemplate as t where lower(t.name) like concat('%', lower(:name), '%') and t.projectId = :projectId")
    public Collection<OperationTemplate> findByPieceOfNameAndProject(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select new org.qubership.automation.itf.core.model.IdNamePair(opTemplate.id, opTemplate.name) from OperationTemplate opTemplate where lower(opTemplate.name) like concat('%', lower(:name), '%') and opTemplate.parent.id = :parentId")
    public List<IdNamePair> findByPieceOfNameAndParentId(@Param(value="name") String var1, @Param(value="parentId") BigInteger var2);

    @Query(value="select t.id, t.name from mb_templates t where t.project_id = :projectId", nativeQuery=true)
    public List<Object[]> findIdAndNameByProjectId(@Param(value="projectId") BigInteger var1);

    @Query(value="select t from OperationTemplate  as t where id = :id")
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="operationTemplateCache")})
    public OperationTemplate findByIdOnly(@Param(value="id") BigInteger var1);
}

