/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import javax.persistence.QueryHint;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.template.OutboundTemplateTransportConfiguration;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OutboundTransportConfigurationRepository
extends StorableRepository<OutboundTransportConfiguration>,
QuerydslPredicateExecutor<OutboundTransportConfiguration> {
    @Query(value="select otc from OutboundTransportConfiguration otc where otc.ecId = :ecId")
    public OutboundTransportConfiguration findByEcId(@Param(value="ecId") String var1);

    @Query(value="select ec_project_id from mb_configuration where type='outbound' and ec_project_id is not null and parent_out_server_id in (select id from mb_servers where project_id = :projectId) group by ec_project_id", nativeQuery=true)
    public Collection<String> getEcProjectIds(@Param(value="projectId") BigInteger var1);

    @Query(value="select otc from OutboundTransportConfiguration otc where otc.ecProjectId = :ecProjectId")
    public Collection<OutboundTransportConfiguration> getByEcProject(@Param(value="ecProjectId") String var1);

    @Modifying
    @Query(value="update mb_configuration set ec_project_id = null, ec_id = null where ec_project_id = :ecProjectId and type='outbound'", nativeQuery=true)
    public void unbindByEcProject(@Param(value="ecProjectId") String var1);

    @Query(value="select conf from OutboundTemplateTransportConfiguration conf where parent_template_id = :templateId")
    public Collection<OutboundTemplateTransportConfiguration> findAllCfgByTemplate(@Param(value="templateId") BigInteger var1);

    @Query(value="select conf from OutboundTemplateTransportConfiguration conf where parent_template_id = :templateId and type_name = :typeName")
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="outboundTemplateTransportConfigurationsCollectionCache")})
    public Collection<OutboundTemplateTransportConfiguration> findCfgByTemplateAndType(@Param(value="templateId") BigInteger var1, @Param(value="typeName") String var2);

    @Query(value="select otc.* from mb_configuration otc where otc.parent_out_server_id = :serverId and otc.system_id = :systemId and otc.type_name = :typeName", nativeQuery=true)
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="outboundTransportConfigurationCache")})
    public OutboundTransportConfiguration findOne(@Param(value="systemId") BigInteger var1, @Param(value="serverId") BigInteger var2, @Param(value="typeName") String var3);

    @Query(value="select otc.* from mb_configuration otc where otc.parent_out_server_id = :serverId and otc.system_id = :systemId", nativeQuery=true)
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="outboundTransportConfigurationsCollectionCache")})
    public Iterable<OutboundTransportConfiguration> findAll(@Param(value="systemId") BigInteger var1, @Param(value="serverId") BigInteger var2);
}

