/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.List;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@JaversSpringDataAuditable
@Repository
public interface StepRepository
extends StorableRepository<Step>,
QuerydslPredicateExecutor<Step> {
    @Modifying
    @Query(value="update IntegrationStep step set step.systemTemplate = null where step.systemTemplate = :template")
    public void onDeleteSystemTemplate(@Param(value="template") Template var1);

    @Modifying
    @Query(value="update IntegrationStep step set step.operationTemplate = null where step.operationTemplate = :template")
    public void onDeleteOperationTemplate(@Param(value="template") Template var1);

    @Modifying
    @Query(value="update IntegrationStep step set step.sender = null where step.sender = :system")
    public void onDeleteSystemSender(@Param(value="system") System var1);

    @Modifying
    @Query(value="update IntegrationStep step set step.receiver = null where step.receiver = :system")
    public void onDeleteSystemReceiver(@Param(value="system") System var1);

    @Modifying
    @Query(value="update IntegrationStep step set step.operation = null where step.operation = :operation")
    public void onDeleteOperation(@Param(value="operation") Operation var1);

    @Modifying
    @Query(value="update EmbeddedStep step set step.chain = null where step.chain = :callChain")
    public void onDeleteCallChain(@Param(value="callChain") CallChain var1);

    @Modifying
    @Query(value="update SituationStep step set step.situation = null where step.situation = :situation")
    public void onDeleteSituation(@Param(value="situation") Situation var1);

    @Query(value="select step from IntegrationStep step where step.systemTemplate = :template")
    public Iterable<Step> getIntegrationStepsBySystemTemplate(@Param(value="template") SystemTemplate var1);

    @Query(value="select step from IntegrationStep step where step.operationTemplate = :template")
    public Iterable<Step> getIntegrationStepsByOperationTemplate(@Param(value="template") OperationTemplate var1);

    @Query(value="select step from IntegrationStep step where step.operation = :operation")
    public Iterable<Step> getIntegrationStepsByOperation(@Param(value="operation") Operation var1);

    @Query(value="select step from IntegrationStep step where step.sender = :system")
    public Iterable<Step> getIntegrationStepsBySender(@Param(value="system") System var1);

    @Query(value="select step from IntegrationStep step where step.receiver = :system")
    public Iterable<Step> getIntegrationStepsByReceiver(@Param(value="system") System var1);

    @Query(value="select id from mb_steps where situation_id = :situationId union select step_id from mb_end_situations where situation_id = :situationId union select step_id from mb_exceptional_situation where situation_id = :situationId", nativeQuery=true)
    public List<BigInteger> getIdsSteps(@Param(value="situationId") BigInteger var1);

    @Query(value="SELECT id, name from mb_step_container where id in (select id from mb_chain where project_id = :projectId) order by name", nativeQuery=true)
    public List<Object[]> findIdAndNameByProjectId(@Param(value="projectId") BigInteger var1);
}

