/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.RootRepository;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@JaversSpringDataAuditable
@Repository
public interface StubProjectRepository
extends RootRepository<StubProject> {
    @Modifying
    @Query(value="SET session_replication_role = 'replica'", nativeQuery=true)
    public void setReplicationRoleReplica();

    @Modifying
    @Query(value="SET session_replication_role = 'origin'", nativeQuery=true)
    public void setReplicationRoleOrigin();

    @Query(value="select id from mb_projects where uuid = :projectUuid", nativeQuery=true)
    public BigInteger getEntityInternalIdByUuid(@Param(value="projectUuid") UUID var1);

    @Query(value="select project from StubProject as project where uuid = :projectUuid")
    public StubProject getByUuid(@Param(value="projectUuid") UUID var1);

    @Query(value="select value from mb_userdata where userkey = :keyParam and project_id = :projectId", nativeQuery=true)
    public List<String> getData(@Param(value="keyParam") String var1, @Param(value="projectId") BigInteger var2);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="insert into mb_userdata (project_id, userkey, value) values (:projectId, :keyParam, :valueParam)", nativeQuery=true)
    public void setData(@Param(value="keyParam") String var1, @Param(value="valueParam") String var2, @Param(value="projectId") BigInteger var3);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="update mb_userdata SET value = :valueParam where userkey = :keyParam and project_id = :projectId", nativeQuery=true)
    public void updateData(@Param(value="keyParam") String var1, @Param(value="valueParam") String var2, @Param(value="projectId") BigInteger var3);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="insert into mb_userdata (project_id, userkey, value) values (:projectId, :keyParam, :valueParam) on conflict (userkey, project_id) do update set value = :valueParam where EXCLUDED.userkey = :keyParam and EXCLUDED.project_id = :projectId", nativeQuery=true)
    public void upsertData(@Param(value="keyParam") String var1, @Param(value="valueParam") String var2, @Param(value="projectId") BigInteger var3);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="delete from mb_userdata where userkey = :keyParam and project_id = :projectId", nativeQuery=true)
    public void deleteData(@Param(value="keyParam") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select clear_user_data_func(:leaveDays)", nativeQuery=true)
    public String clearUserData(@Param(value="leaveDays") Integer var1);

    @Query(value="select mb_systems.project_id as id, ''||mb_projects.uuid as project_uuid from mb_systems inner join mb_projects on mb_systems.project_id = mb_projects.id where mb_systems.id = :systemId", nativeQuery=true)
    public List<String[]> determineProjectIdsBySystemId(@Param(value="systemId") BigInteger var1);

    @Query(value="select prop_value from mb_project_settings where project_id = :projectId and prop_short_name = :propertyName", nativeQuery=true)
    public String getProjectSetting(@Param(value="projectId") BigInteger var1, @Param(value="propertyName") String var2);

    @Query(value="select prop_short_name, prop_value from mb_project_settings where project_id = :projectId", nativeQuery=true)
    public List<Object[]> getAllProjectSettingsByProjectId(@Param(value="projectId") BigInteger var1);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="update mb_project_settings set prop_value = :propValue where project_id = :projectId and prop_short_name = :propShortName", nativeQuery=true)
    public void updateProjectSetting(@Param(value="projectId") BigInteger var1, @Param(value="propShortName") String var2, @Param(value="propValue") String var3);
}

