/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.QueryHint;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface SystemRepository
extends StorableRepository<System> {
    @Query(value="select oper from Operation oper where parent_id = :parentId and definition_key = :key ")
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="operationByDefinitionKeyCache")})
    public Operation findFirstByDefineOperation(@Param(value="parentId") BigInteger var1, @Param(value="key") String var2);

    @Query(value="select distinct s_labels.labels as labels from mb_systems as s inner join mb_systems_labels as s_labels on s_labels.id = s.id where project_id = :projectId union select distinct mfl.labels as labels from mb_folders as mf inner join mb_folders_labels as mfl on mfl.id =mf.id where mf.\"type\" = 'systems' and mf.project_id = :projectId", nativeQuery=true)
    public Set<String> getAllLabels(@Param(value="projectId") BigInteger var1);

    @Query(value="select sys from System sys where sys.ecId = :ecId")
    public System findSystemByEcId(@Param(value="ecId") String var1);

    @Query(value="select ec_project_id from mb_systems where ec_project_id is not null and project_id = :projectId group by ec_project_id", nativeQuery=true)
    public Collection<String> getEcProjectIds(@Param(value="projectId") BigInteger var1);

    @Query(value="select system from System system where system.ecProjectId = :ecProjectId")
    public Collection<System> getSystemsByEcProject(@Param(value="ecProjectId") String var1);

    @Modifying
    @Query(value="update mb_systems set ec_project_id = null, ec_id = null, ec_label = null where ec_project_id = :ecProjectId", nativeQuery=true)
    public void unbindByEcProject(@Param(value="ecProjectId") String var1);

    @Query(value="select sys from System sys where sys.ecLabel = :ecLabel and sys.projectId = :projectId and sys.ecId is not null")
    public System findByEcLabel(@Param(value="ecLabel") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select system from System system where lower(system.name) like concat('%', lower(:name), '%') and system.projectId = :projectId")
    public Collection<System> findByPieceOfNameAndProject(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select system from System system where system.projectId = :projectId")
    public Collection<System> findByProject(@Param(value="projectId") BigInteger var1);

    @Query(value="select distinct receiver_id FROM mb_steps WHERE parent_id in (     SELECT distinct situation_id     FROM mb_steps     WHERE parent_id in (         WITH RECURSIVE embedded_steps (chain_id) AS (         SELECT distinct chain_id         FROM mb_steps         WHERE parent_id = :chainId             and enabled and \"type\"='embedded' and chain_id is not null         UNION         SELECT distinct p.chain_id         FROM mb_steps p         INNER JOIN embedded_steps ON embedded_steps.chain_id = p.parent_id              and p.enabled and p.\"type\"='embedded' and p.chain_id is not null         )         select * from embedded_steps         union         select :chainId     )     and enabled and \"type\"='situation' and situation_id is not null )", nativeQuery=true)
    public List<BigInteger> getReceiverSystemIdsFromCallChainSteps(@Param(value="chainId") BigInteger var1);

    @Query(value="select new org.qubership.automation.itf.core.model.IdNamePair(system.id, system.name) from System as system where system.projectId = :projectId")
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="simpleSystemListByProjectCache")})
    public List<IdNamePair> getSimpleListByProject(@Param(value="projectId") BigInteger var1);

    @Query(value="select id from mb_configuration where parent_conf_id in (select id from mb_configuration where transport_id in   (select id from mb_configuration where parent_system_id = :systemId))", nativeQuery=true)
    public List<BigInteger> getTransportTriggersBySystemId(@Param(value="systemId") BigInteger var1);

    @Query(value="select id from mb_triggers where set_parent_id in (select id from mb_situation where parent_id in   (select id from mb_operations where parent_id = :systemId))", nativeQuery=true)
    public List<BigInteger> getSituationEventTriggersBySystemId(@Param(value="systemId") BigInteger var1);
}

