/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import javax.persistence.QueryHint;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.TemplateRepository;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@JaversSpringDataAuditable
public interface SystemTemplateRepository
extends TemplateRepository<System, SystemTemplate> {
    @Override
    @Query(value="select systemTemplate from SystemTemplate as systemTemplate inner join System as system on system = systemTemplate.parent where systemTemplate.name = :name and system.ID = :parentId")
    public List<SystemTemplate> findByParentIDAndName(@Param(value="parentId") Object var1, @Param(value="name") String var2);

    @Override
    @Query(value="select template.* from mb_templates template where template.type = 'system' and template.parent_system_id = :parentId", nativeQuery=true)
    public List<SystemTemplate> findByParentID(@Param(value="parentId") Object var1);

    @Query(value="select new org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate(systemTemplate.id, systemTemplate.name) from SystemTemplate as systemTemplate where systemTemplate.parent.id = :parentId")
    public List<SystemTemplate> findSimpleSystemTemplatesByParentId(@Param(value="parentId") BigInteger var1);

    @Override
    @Query(value="select systemTemplate from SystemTemplate as systemTemplate inner join System as system on system = systemTemplate.parent where system.name = :name")
    public List<SystemTemplate> findByParentName(@Param(value="name") String var1);

    @Query(value="select t from SystemTemplate as t where lower(t.name) like concat('%', lower(:name), '%') and t.projectId = :projectId")
    public Collection<SystemTemplate> findByPieceOfNameAndProject(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select new org.qubership.automation.itf.core.model.IdNamePair(sysTemplate.id, sysTemplate.name) from SystemTemplate as sysTemplate where lower(sysTemplate.name) like concat('%', lower(:name), '%') and sysTemplate.parent.id = :parentId")
    public List<IdNamePair> findByPieceOfNameAndParentId(@Param(value="name") String var1, @Param(value="parentId") BigInteger var2);

    @Query(value="select template from SystemTemplate template inner join System as system on system = template.parent where lower(system.name) like concat('%', lower(:name), '%') and system.projectId = :projectId")
    public Collection<SystemTemplate> findByParentNameAndProject(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select t from SystemTemplate  as t where id = :id")
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="systemTemplateCache")})
    public SystemTemplate findByIdOnly(@Param(value="id") BigInteger var1);
}

