/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.reports;

import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.RootRepository;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InstanceContextRepository
extends RootRepository<InstanceContext> {
    @Query(value="select     mp.param_name,     case         when cardinality(mpmv.arr) = 1 then array_to_string(mpmv.arr, '')         else '[' || array_to_string(mpmv.arr, ', ') || ']'     end from     mb_message_param mp     left join lateral (         select array_agg(mpmv.value) as arr         from mb_message_param_multiple_value mpmv         where mpmv.message_param_id = mp.id and mpmv.part_num = :partNum     ) mpmv on true where     mp.context_id = cast(:spcontext_id as int8)     and mp.part_num = :partNum", nativeQuery=true)
    public List<Object[]> getSpMessageParameters(@Param(value="spcontext_id") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select error_name, error_message from mb_instance where id = cast(:instance_id as int8) and part_num = :partNum", nativeQuery=true)
    public List<Object[]> stepInstanceError(@Param(value="instance_id") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select error_name, error_message, \"name\", id from mb_instance where context_id = cast(:tcContextId as int8) and (error_name is not null or error_message is not null) union \nselect error_name, error_message, \"name\", id \nfrom mb_instance \nwhere id=(select initiator_id from mb_tccontext where id = cast(:tcContextId as int8))\nand (error_name is not null or error_message is not null)\nand part_num = :partNum\norder by id", nativeQuery=true)
    public List<Object[]> allTcContextInstancesErrors(@Param(value="tcContextId") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select  case  when \"ID\"  is null then 0 else \"ID\" end as id, case  when \"PARENT\"  is null then 0 else \"PARENT\" end as parent, case  when \"TYPE\"  is null then 'NULL' else \"TYPE\" end as type, case  when \"DESCRIPTION\"   is null then 'NULL' else \"DESCRIPTION\"  end as description,  case  when \"PATH\"  is null then 'NULL' else \"PATH\"  end as path, case  when \"LEVEL\"  is null then 0 else \"LEVEL\" end  as level, case  when \"STATUS\"  is null then 'NULL' else \"STATUS\"  end as status, case  when \"DURATION\"   is null then 'NULL' else \"DURATION\" end as duration, case  when \"START_TIME\"   is null then 'NULL' else \"START_TIME\" end as start_time, case  when \"END_TIME\"   is null then 'NULL' else \"END_TIME\" end as end_time from  get_messages_from_tc_context_no_message(cast(:tcContextId as int8), cast(:partNum as smallint)) order by start_time, type ", nativeQuery=true)
    public List<Object[]> getTcContextTree(@Param(value="tcContextId") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select sp_ctx.id, sp_ctx.incoming_message_id, sp_ctx.outgoing_message_id, sp_ctx.json_string from mb_context some_ctx inner join mb_context sp_ctx on sp_ctx.parent_ctx_id = some_ctx.id   and sp_ctx.part_num = some_ctx.part_num where some_ctx.\"instance\" = cast(:stepinstanceid as int8) and some_ctx.part_num = :partNum", nativeQuery=true)
    public List<Object[]> getMessageIds(@Param(value="stepinstanceid") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select text from mb_message where id = cast(:message_id as int8) and part_num = :partNum", nativeQuery=true)
    public String getMessageText(@Param(value="message_id") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select key, value from mb_message_headers where parent_id = cast(:message_id as int8) and part_num = :partNum", nativeQuery=true)
    public List<Object[]> getMessageHeaders(@Param(value="message_id") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select key, value from mb_message_connection_properties where parent_id = cast(:message_id as int8) and part_num = :partNum", nativeQuery=true)
    public List<Object[]> getMessageConnectionProperties(@Param(value="message_id") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select key, value from mb_context_report_links where parent_id = cast(:tcContextId as int8) and part_num = :partNum", nativeQuery=true)
    public List<Object[]> getTcContextReportLinks(@Param(value="tcContextId") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select key from mb_context_binding_keys where id = cast(:tcContextId as int8) and part_num = :partNum", nativeQuery=true)
    public Set<String> getTcContextBindingKeys(@Param(value="tcContextId") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select key from mb_context_binding_keys where id = cast(:tcContextId as int8)", nativeQuery=true)
    public Set<String> getTcContextBindingKeys(@Param(value="tcContextId") BigInteger var1);

    @Query(value="select  ctx.id, ctx.name, ctx.initiator_id, ctx.environment_id,  ctx.status, ctx.start_time, ctx.end_time, ctx.json_string, ctx.project_id from mb_context ctx where ctx.id = cast(:tcContextId as int8)", nativeQuery=true)
    public List<Object[]> getTcContextInfo(@Param(value="tcContextId") BigInteger var1);

    @Query(value="select ctx.json_string from mb_context ctx where ctx.id = cast(:tcContextId as int8) and ctx.part_num = :partNum", nativeQuery=true)
    public String getContextVariables(@Param(value="tcContextId") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select ctx.json_string from mb_context ctx where ctx.id = cast(:tcContextId as int8)", nativeQuery=true)
    public String getContextVariables(@Param(value="tcContextId") BigInteger var1);

    @Query(value="select ini.name, ini.type, ini.situation_id, ini.chain_id, ini.callchain_execution_data, ini.operation_name, ini.system_name, ini.system_id from mb_instance ini where ini.id = cast(:initiator_id as int8) and ini.part_num = :partNum", nativeQuery=true)
    public List<Object[]> getTcContextInitiatorInfo(@Param(value="initiator_id") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select validation_results from mb_context where id = cast(:spcontext_id as int8) and part_num = :partNum", nativeQuery=true)
    public String getValidationResults(@Param(value="spcontext_id") BigInteger var1, @Param(value="partNum") Integer var2);

    @Query(value="select id, situation_id from mb_instance where context_id = cast(:tcContextId as int8) and situation_id is not null and part_num = :partNum", nativeQuery=true)
    public List<Object[]> getTcContextStepsSituations(@Param(value="tcContextId") BigInteger var1, @Param(value="partNum") Integer var2);
}

