/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.condition;

import java.util.ArrayDeque;
import java.util.List;
import org.qubership.automation.itf.core.model.condition.parameter.ConditionParameter;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.util.constants.Etc;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionsHelper {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConditionsHelper.class);

    public static void fillConditionParameters(List<ConditionParameter> toConditionParameters, List<ConditionParameter> fromConditionParameters) {
        StorableUtils.fillCollection(toConditionParameters, fromConditionParameters);
    }

    private static boolean checkCondition(JsonContext context, ConditionParameter conditionParameter) {
        return conditionParameter.applicable(context);
    }

    public static boolean isApplicable(JsonContext context, List<ConditionParameter> conditionParameters) {
        if (conditionParameters == null || conditionParameters.isEmpty()) {
            LOGGER.info("Conditions list is empty, applicable anyway");
            return true;
        }
        ArrayDeque<Etc> etcQueue = new ArrayDeque<Etc>();
        for (ConditionParameter conditionParameter : conditionParameters) {
            if (conditionParameter.getEtc() == null) continue;
            etcQueue.add(conditionParameter.getEtc());
        }
        boolean result = ConditionsHelper.checkCondition(context, conditionParameters.get(0));
        block5: for (int i = 1; i < conditionParameters.size() && (etcQueue.contains((Object)Etc.OR) || result); ++i) {
            Etc etc = (Etc)((Object)etcQueue.poll());
            if (etc == null) {
                throw new IllegalStateException(String.format("Etc attribute was not specified for condition property %s, don't know how to process...", conditionParameters.get(i - 1).getName()));
            }
            switch (etc) {
                case AND: {
                    result = result && ConditionsHelper.checkCondition(context, conditionParameters.get(i));
                    continue block5;
                }
                case OR: {
                    result = result || ConditionsHelper.checkCondition(context, conditionParameters.get(i));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Illegal boolean operation: %s", new Object[]{etc}));
                }
            }
        }
        return result;
    }
}

