/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.condition.parameter;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.util.constants.Condition;
import org.qubership.automation.itf.core.util.constants.Etc;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.services.CoreServices;

public class ConditionParameter
implements Serializable {
    private static final long serialVersionUID = 20250303L;
    private String name;
    private Condition condition;
    private String value;
    private Etc etc;
    private int orderId;

    public boolean applicable(JsonContext context) {
        if (this.condition == null) {
            return false;
        }
        if (Condition.EXISTS.equals((Object)this.condition)) {
            return context.containsKey(this.getName());
        }
        if (Condition.NOTEXISTS.equals((Object)this.condition)) {
            return !context.containsKey(this.getName());
        }
        if (!context.containsKey(this.getName()) && context instanceof InstanceContext) {
            return Boolean.parseBoolean(CoreServices.getProjectSettingsService().get(((InstanceContext)context).tc().getProjectId(), "conditions.style.legacy", "false")) && (Condition.NOTEQUALS.equals((Object)this.condition) || Condition.NOTMATCHES.equals((Object)this.condition));
        }
        Object keyValue = context.get(this.getName());
        String stringValue = keyValue == null ? "" : keyValue.toString();
        String processedValue = TemplateEngineFactory.process(null, this.value, context);
        switch (this.condition) {
            case EQUALS: {
                return stringValue.equals(processedValue);
            }
            case NOTEQUALS: {
                return !stringValue.equals(processedValue);
            }
            case MATCHES: 
            case NOTMATCHES: {
                Pattern pattern = Pattern.compile(processedValue);
                Matcher matcher = pattern.matcher(stringValue);
                return this.isKeyFound(matcher);
            }
            case LESS: {
                return this.less(stringValue, processedValue);
            }
            case GREATER: {
                return this.less(processedValue, stringValue);
            }
        }
        return false;
    }

    private boolean isKeyFound(Matcher matcher) {
        return Condition.MATCHES.equals((Object)this.condition) == matcher.matches();
    }

    private boolean less(String left, String right) {
        try {
            float num1 = Float.parseFloat(left);
            float num2 = Float.parseFloat(right);
            return num1 < num2;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return "ConditionParameter{name='" + this.getName() + '\'' + ", condition=" + (Object)((Object)this.condition) + ", value='" + this.value + '\'' + ", etc=" + (Object)((Object)this.etc) + ", orderId=" + this.orderId + '}';
    }

    public String getName() {
        return this.name;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String getValue() {
        return this.value;
    }

    public Etc getEtc() {
        return this.etc;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setEtc(Etc etc) {
        this.etc = etc;
    }

    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }
}

