/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.event;

import com.google.common.collect.Maps;
import java.util.Map;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;

public abstract class CallChainEvent
extends Event {
    private CallChainInstance instance;

    public CallChainEvent(CallChainInstance callChainInstance) {
        this.instance = callChainInstance;
    }

    public CallChainInstance getInstance() {
        return this.instance;
    }

    public void setInstance(CallChainInstance instance) {
        this.instance = instance;
    }

    public static class Terminate
    extends CallChainEvent {
        public Terminate(CallChainInstance callChain) {
            super(callChain);
        }
    }

    public static class Finish
    extends CallChainEvent {
        private boolean isFinish = true;

        public Finish(CallChainInstance callChain) {
            super(callChain);
        }

        public boolean isFinish() {
            return this.isFinish;
        }
    }

    public static class Start
    extends CallChainEvent {
        private Map<String, String> reportLinks;

        public Start(CallChainInstance callChain) {
            super(callChain);
            this.reportLinks = Maps.newHashMap(callChain.getContext().tc().getReportLinks());
        }

        public Map<String, String> getReportLinks() {
            return this.reportLinks;
        }
    }
}

