/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.extension;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.qubership.automation.itf.core.model.extension.Extendable;
import org.qubership.automation.itf.core.model.extension.Extension;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;

public class ExtendableImpl
extends AbstractStorable
implements Extendable,
Serializable {
    private static final long serialVersionUID = 20240812L;
    private Set<Extension> extensions = Sets.newHashSetWithExpectedSize((int)5);

    @Override
    public boolean extend(Extension extension) {
        return this.extensions.add(extension);
    }

    @Override
    @JsonIgnore
    public <T extends Extension> T getExtension(Class<T> extensionClass) {
        for (Extension extension : this.extensions) {
            if (!extensionClass.isAssignableFrom(extension.getClass())) continue;
            return (T)((Extension)extensionClass.cast(extension));
        }
        return null;
    }

    @Override
    public String getExtensionsJson() {
        Gson gson = new Gson();
        JsonObject result = new JsonObject();
        for (Extension extension : this.extensions) {
            result.add(extension.getClass().getName(), gson.toJsonTree((Object)extension));
        }
        return gson.toJson((JsonElement)result);
    }

    @Override
    public void setExtensionsJson(String extensionsJson) {
        if (extensionsJson != null) {
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = parser.parse(extensionsJson).getAsJsonObject();
            Gson gson = new Gson();
            this.extensions.clear();
            for (Map.Entry entry : jsonObject.entrySet()) {
                int idx = ((String)entry.getKey()).indexOf("$$");
                String className = idx > 1 ? ((String)entry.getKey()).substring(0, idx) : (String)entry.getKey();
                try {
                    Class<Extension> clazz = Class.forName(className).asSubclass(Extension.class);
                    Extension extension = (Extension)gson.fromJson((JsonElement)entry.getValue(), clazz);
                    this.extensions.add(extension);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn("Cannot read extension - class not found {}", (Object)className);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot read extension - {}; runtime exception: {}", (Object)className, (Object)e);
                }
            }
        }
    }
}

