/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.interceptor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.jpa.interceptor.ApplicabilityParams;
import org.qubership.automation.itf.core.model.jpa.interceptor.InterceptorParams;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;
import org.qubership.automation.itf.core.util.loader.InterceptorClassLoader;

public class CommonInterceptor
extends AbstractStorable
implements Storable,
Interceptor {
    private static final long serialVersionUID = 20240812L;
    private List<InterceptorParams> interceptorParams = Lists.newArrayList();
    private String typeName;
    private String transportName;
    private boolean active = false;
    private int order;
    private String interceptorGroup;
    private List<ApplicabilityParams> applicabilityParams = Lists.newArrayList();

    @Override
    @JsonIgnore
    public InterceptorParams getParameters() {
        return this.interceptorParams.isEmpty() ? null : this.interceptorParams.get(0);
    }

    @Override
    @JsonManagedReference
    public List<InterceptorParams> getInterceptorParams() {
        return this.interceptorParams;
    }

    @Override
    @JsonManagedReference
    public List<ApplicabilityParams> getApplicabilityParams() {
        return this.applicabilityParams;
    }

    @Override
    public boolean isApplicable(String environmentId, String systemId) {
        if (this.applicabilityParams.isEmpty()) {
            return true;
        }
        for (ApplicabilityParams params : this.applicabilityParams) {
            String applicableEnvId = params.get("Environment");
            String applicableSystemId = params.get("System");
            if (StringUtils.isEmpty((CharSequence)applicableEnvId) && StringUtils.isEmpty((CharSequence)applicableSystemId)) {
                return false;
            }
            if (!(StringUtils.isEmpty((CharSequence)applicableSystemId) ? applicableEnvId.equals(environmentId) : applicableEnvId.equals(environmentId) && applicableSystemId.equals(systemId))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String validate() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        try {
            return InterceptorClassLoader.getInstance().getInstanceClass(this.getTypeName(), this).validate();
        }
        catch (ClassNotFoundException e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        this.getInterceptorParams().forEach(interceptor -> interceptor.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
        this.getApplicabilityParams().forEach(applicabilityParam -> applicabilityParam.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getTransportName() {
        return this.transportName;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String getInterceptorGroup() {
        return this.interceptorGroup;
    }

    @Override
    public void setInterceptorParams(List<InterceptorParams> interceptorParams) {
        this.interceptorParams = interceptorParams;
    }

    @Override
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void setInterceptorGroup(String interceptorGroup) {
        this.interceptorGroup = interceptorGroup;
    }

    @Override
    public void setApplicabilityParams(List<ApplicabilityParams> applicabilityParams) {
        this.applicabilityParams = applicabilityParams;
    }
}

