/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.interceptor;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.interceptor.TransportInterceptor;
import org.qubership.automation.itf.core.model.jpa.interceptor.InterceptorParams;
import org.qubership.automation.itf.core.model.jpa.message.Message;

public class InterceptorChain {
    private List<Interceptor> interceptors = new ArrayList<Interceptor>(10);

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void add(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void remove(Interceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    @Nonnull
    public Message apply(@Nonnull Message message) throws Exception {
        Message data = message;
        for (Interceptor interceptor : this.interceptors) {
            if (!interceptor.isActive()) continue;
            TransportInterceptor transportInterceptor = (TransportInterceptor)Class.forName(interceptor.getTypeName()).getConstructor(InterceptorParams.class).newInstance(interceptor);
            data = transportInterceptor.apply(data);
        }
        return data;
    }
}

