/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.callchain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.folder.ChainFolder;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.project.StubContainer;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.testcase.AbstractTestCase;
import org.qubership.automation.itf.core.util.annotation.NoCopy;
import org.qubership.automation.itf.core.util.annotation.ProduceNewObject;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.ei.deserialize.ChainFolderDeserializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=CallChain.class)
public class CallChain
extends AbstractTestCase {
    private static final long serialVersionUID = 20240812L;
    private Set<String> keys = Sets.newHashSet();
    private Map<String, String> bvCases = Maps.newHashMap();
    private String datasetId;
    private BigInteger projectId;

    public CallChain() {
    }

    public CallChain(Storable parent) {
        this();
        Optional<Folder<CallChain>> callChainFolder;
        Folder actualParent = null;
        if (parent instanceof StubContainer) {
            actualParent = ((StubContainer)((Object)parent)).getCallchains();
        } else if (parent instanceof Folder && (callChainFolder = ((Folder)parent).of(CallChain.class)).isPresent()) {
            actualParent = (Folder)callChainFolder.get();
        }
        if (actualParent == null) {
            throw new RuntimeException("ER: SystemFolder or StubContainer; AR:" + parent);
        }
        this.setParent(parent);
        actualParent.getObjects().add(this);
    }

    public SituationStep addStep(Situation situation) {
        SituationStep situationStep = CoreObjectManager.getInstance().getManager(SituationStep.class).create((Storable)this, situation.getName(), "situationStep");
        situationStep.setSituation(situation);
        return situationStep;
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    protected void setKeys(Set<String> keys) {
        this.keys = keys;
    }

    public void fillKeys(Set<String> keys) {
        StorableUtils.fillCollection(this.getKeys(), keys);
    }

    @NoCopy
    public Map<String, String> getBvCases() {
        return this.bvCases;
    }

    public void setBvCases(Map<String, String> bvCases) {
        this.bvCases = bvCases;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    public BigInteger getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public ChainFolder getParent() {
        return (ChainFolder)super.getParent();
    }

    @JsonDeserialize(using=ChainFolderDeserializer.class)
    public void setParent(ChainFolder parent) {
        super.setParent(parent);
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        super.performPostImportActions(projectId, sessionId);
        this.setProjectId(projectId);
        for (Step step : this.getSteps()) {
            if (step == null) continue;
            step.performPostImportActions(projectId, sessionId);
        }
    }

    @Override
    @ProduceNewObject
    public Object getNaturalId() {
        return super.getNaturalId();
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        this.getSteps().forEach(step -> step.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
    }
}

