/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.context;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.jpa.context.JsonStorable;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter;
import org.qubership.automation.itf.core.util.annotation.JsonRef;

@Entity
@JsonFilter(value="reportWorkerFilter_SPContext")
public class SpContext
extends JsonStorable {
    private static final long serialVersionUID = 20240812L;
    public static final String SP = "sp";
    private List<MessageParameter> messageParameters;
    private StepInstance step;
    private Message incomingMessage;
    private Message outgoingMessage;
    private String validationResults;

    public SpContext(StepInstance step) {
        this.step = step;
        if (step != null) {
            this.setParent(step.getContext());
        }
    }

    public SpContext() {
        this.setStartTime(new Date());
    }

    public List<MessageParameter> getMessageParameters() {
        return this.messageParameters;
    }

    protected void setMessageParameters(List<MessageParameter> messageParameters) {
        this.messageParameters = messageParameters;
    }

    public void putMessageParameters(Collection<MessageParameter> messageParameters) {
        if (this.getMessageParameters() == null) {
            this.setMessageParameters(Lists.newArrayListWithExpectedSize((int)(messageParameters.size() * 2)));
        }
        this.getMessageParameters().addAll(messageParameters);
        for (MessageParameter parameter : messageParameters) {
            parameter.setParent(this);
            this.put(parameter.getParamName(), parameter.isMultiple() ? parameter.getMultipleValue() : parameter.getSingleValue());
        }
    }

    @JsonRef
    public StepInstance getStep() {
        return this.step;
    }

    public void setStep(StepInstance step) {
        this.step = step;
    }

    public Message getIncomingMessage() {
        return this.incomingMessage;
    }

    public void setIncomingMessage(Message incomingMessage) {
        this.incomingMessage = incomingMessage;
    }

    public Message getOutgoingMessage() {
        return this.outgoingMessage;
    }

    public void setOutgoingMessage(Message outgoingMessage) {
        this.outgoingMessage = outgoingMessage;
    }

    public String getValidationResults() {
        return this.validationResults;
    }

    public void setValidationResults(String validationResults) {
        this.validationResults = validationResults;
    }
}

