/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.environment;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Entity;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvironmentManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.eci.AbstractEciConfigurable;
import org.qubership.automation.itf.core.model.eci.EciConfigurable;
import org.qubership.automation.itf.core.model.jpa.folder.EnvFolder;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.project.StubContainer;
import org.qubership.automation.itf.core.model.jpa.report.LinkCollectorConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.ei.deserialize.EnvFolderDeserializer;
import org.qubership.automation.itf.core.util.ei.deserialize.SystemServerMapDeserializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;
import org.qubership.automation.itf.core.util.ei.serialize.StorablesMapSerializer;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=Environment.class)
public class Environment
extends AbstractEciConfigurable {
    private static final long serialVersionUID = 20240812L;
    @JsonSerialize(using=StorablesMapSerializer.class)
    @JsonDeserialize(using=SystemServerMapDeserializer.class)
    private Map<System, Server> outbound = Maps.newHashMapWithExpectedSize((int)10);
    @JsonSerialize(using=StorablesMapSerializer.class)
    @JsonDeserialize(using=SystemServerMapDeserializer.class)
    private Map<System, Server> inbound = Maps.newHashMapWithExpectedSize((int)10);
    private Set<LinkCollectorConfiguration> reportCollectors = Sets.newHashSetWithExpectedSize((int)5);
    private TriggerState environmentState;
    private BigInteger projectId;

    public Environment() {
    }

    public Environment(Storable parent) {
        Optional<Folder<Environment>> environmentFolder;
        Folder actualParent = null;
        if (parent instanceof StubContainer) {
            actualParent = ((StubContainer)((Object)parent)).getEnvironments();
        } else if (parent instanceof Folder && (environmentFolder = ((Folder)parent).of(Environment.class)).isPresent()) {
            actualParent = (Folder)environmentFolder.get();
        }
        if (actualParent == null) {
            throw new RuntimeException("EnvironmentFolder or StubContainer are expected, but given: " + parent);
        }
        this.setParent(actualParent);
        actualParent.getObjects().add(this);
    }

    public TriggerState getEnvironmentState() {
        return this.environmentState;
    }

    public void setEnvironmentState(TriggerState environmentState) {
        this.environmentState = environmentState;
    }

    public Map<System, Server> getOutbound() {
        return this.outbound;
    }

    protected void setOutbound(Map<System, Server> outbound) {
        this.outbound = outbound;
    }

    public void fillOutbound(Map<System, Server> outbound) {
        StorableUtils.fillMap(this.getOutbound(), outbound);
    }

    public Map<System, Server> getInbound() {
        return this.inbound;
    }

    protected void setInbound(Map<System, Server> inbound) {
        this.inbound = inbound;
    }

    public void fillInbound(Map<System, Server> inbound) {
        StorableUtils.fillMap(this.getInbound(), inbound);
    }

    public Set<LinkCollectorConfiguration> getReportCollectors() {
        return this.reportCollectors;
    }

    protected void setReportCollectors(Set<LinkCollectorConfiguration> reportCollectors) {
        this.reportCollectors = reportCollectors;
    }

    public void fillReportCollectors(Set<LinkCollectorConfiguration> reportCollectors) {
        StorableUtils.fillCollection(this.reportCollectors, reportCollectors);
    }

    @Override
    public BigInteger getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }

    @Override
    @JsonSerialize(using=IdSerializer.class)
    public EnvFolder getParent() {
        return (EnvFolder)super.getParent();
    }

    @JsonDeserialize(using=EnvFolderDeserializer.class)
    public void setParent(EnvFolder parent) {
        super.setParent(parent);
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        super.performPostImportActions(projectId, sessionId);
        this.setProjectId(projectId);
        HashSet importedSystems = Sets.newHashSet();
        HashSet importedServers = Sets.newHashSet();
        this.getSystemsAndServersFromImport(this.getInbound(), importedSystems, importedServers);
        this.getSystemsAndServersFromImport(this.getOutbound(), importedSystems, importedServers);
        for (System system : importedSystems) {
            system.performPostImportActions(projectId, sessionId);
        }
        for (Server server : importedServers) {
            server.performPostImportActions(projectId, sessionId);
        }
        this.reportLinkPostActions();
    }

    private void getSystemsAndServersFromImport(Map<System, Server> systemServerMap, Set<System> importedSystems, Set<Server> importedServers) {
        for (Map.Entry<System, Server> entry : systemServerMap.entrySet()) {
            importedSystems.add(entry.getKey());
            if (entry.getValue() == null) continue;
            importedServers.add(entry.getValue());
        }
    }

    private void reportLinkPostActions() {
        for (LinkCollectorConfiguration linkCollectorConfiguration : this.getReportCollectors()) {
            System linkedSystem;
            String systemId;
            Map<String, String> configuration = linkCollectorConfiguration.getConfiguration();
            if (configuration == null || !StringUtils.isNotEmpty((CharSequence)(systemId = configuration.get("system"))) || (linkedSystem = CoreObjectManager.getInstance().getManager(System.class).getById(systemId)) != null) continue;
            configuration.remove("system");
        }
    }

    @Override
    public void unbindEntityWithHierarchy() {
        Pair<Set<EciConfigurable>, Set<EciConfigurable>> systemsAndServers = this.getSystemsAndServersForUnbind();
        this.unbindEntities((Set)systemsAndServers.getLeft());
        this.unbindEntities((Set)systemsAndServers.getRight());
        this.setEciParameters(null, null);
    }

    private Pair<Set<EciConfigurable>, Set<EciConfigurable>> getSystemsAndServersForUnbind() {
        HashSet systems = Sets.newHashSet();
        HashSet servers = Sets.newHashSet();
        for (Map.Entry<System, Server> entry : this.getOutbound().entrySet()) {
            systems.add(entry.getKey());
            if (entry.getValue() == null) continue;
            servers.add(entry.getValue());
        }
        for (Map.Entry<System, Server> entry : this.getInbound().entrySet()) {
            systems.add(entry.getKey());
            if (entry.getValue() == null) continue;
            servers.add(entry.getValue());
        }
        return new ImmutablePair((Object)systems, (Object)servers);
    }

    private void unbindEntities(Set<EciConfigurable> entitiesForUnbind) {
        EnvironmentManager environmentManager = CoreObjectManager.getInstance().getSpecialManager(Environment.class, EnvironmentManager.class);
        for (EciConfigurable entity : entitiesForUnbind) {
            Collection<String> environmentEcIds;
            if (entity.getEcId() == null || (environmentEcIds = entity instanceof System ? environmentManager.findEnvironmentEcIdsForSystem((BigInteger)entity.getID()) : environmentManager.findEnvironmentEcIdsForServer((BigInteger)entity.getID())) == null || environmentEcIds.size() != 1) continue;
            entity.unbindEntityWithHierarchy();
        }
    }

    @Override
    public void upStorableVersion() {
        super.upStorableVersion();
        HashSet importedSystems = Sets.newHashSet();
        HashSet importedServers = Sets.newHashSet();
        this.getSystemsAndServersFromImport(this.getInbound(), importedSystems, importedServers);
        this.getSystemsAndServersFromImport(this.getOutbound(), importedSystems, importedServers);
        for (System system : importedSystems) {
            system.upStorableVersion();
        }
        for (Server server : importedServers) {
            server.upStorableVersion();
        }
        this.reportLinkPostActions();
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        this.outbound.forEach((key, value) -> Environment.processServer(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId, value));
        this.inbound.forEach((key, value) -> Environment.processServer(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId, value));
    }

    private static void processServer(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId, Server value) {
        if (value != null) {
            value.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        }
    }
}

